/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinition;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CharFilter
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<CharFilter> _DESERIALIZER = JsonpDeserializer.lazy(CharFilter::buildCharFilterDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private CharFilter(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private CharFilter(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static CharFilter of(Function<Builder, ObjectBuilder<CharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isDefinition() {
        return this._kind == Kind.Definition;
    }

    public CharFilterDefinition definition() {
        return (CharFilterDefinition)TaggedUnionUtils.get(this, Kind.Definition);
    }

    public boolean isName() {
        return this._kind == Kind.Name;
    }

    public String name() {
        return (String)TaggedUnionUtils.get(this, Kind.Name);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Name: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<CharFilter> buildCharFilterDeserializer() {
        return new UnionDeserializer.Builder<CharFilter, Kind, Object>(CharFilter::new, false).addMember(Kind.Definition, CharFilterDefinition._DESERIALIZER).addMember(Kind.Name, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CharFilter> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<CharFilter> definition(CharFilterDefinition v) {
            this._kind = Kind.Definition;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilter> definition(Function<CharFilterDefinition.Builder, ObjectBuilder<CharFilterDefinition>> fn) {
            return this.definition(fn.apply(new CharFilterDefinition.Builder()).build());
        }

        public ObjectBuilder<CharFilter> name(String v) {
            this._kind = Kind.Name;
            this._value = v;
            return this;
        }

        @Override
        public CharFilter build() {
            this._checkSingleUse();
            return new CharFilter(this);
        }
    }

    public static enum Kind {
        Definition,
        Name;

    }
}

