/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelInferenceStats
implements JsonpSerializable {
    private final long failureCount;
    private final long inferenceCount;
    private final long cacheMissCount;
    private final long missingAllFieldsCount;
    private final Time timestamp;
    public static final JsonpDeserializer<TrainedModelInferenceStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelInferenceStats::setupTrainedModelInferenceStatsDeserializer);

    private TrainedModelInferenceStats(Builder builder) {
        this.failureCount = ApiTypeHelper.requireNonNull(builder.failureCount, this, "failureCount");
        this.inferenceCount = ApiTypeHelper.requireNonNull(builder.inferenceCount, this, "inferenceCount");
        this.cacheMissCount = ApiTypeHelper.requireNonNull(builder.cacheMissCount, this, "cacheMissCount");
        this.missingAllFieldsCount = ApiTypeHelper.requireNonNull(builder.missingAllFieldsCount, this, "missingAllFieldsCount");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static TrainedModelInferenceStats of(Function<Builder, ObjectBuilder<TrainedModelInferenceStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long failureCount() {
        return this.failureCount;
    }

    public final long inferenceCount() {
        return this.inferenceCount;
    }

    public final long cacheMissCount() {
        return this.cacheMissCount;
    }

    public final long missingAllFieldsCount() {
        return this.missingAllFieldsCount;
    }

    public final Time timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failure_count");
        generator.write(this.failureCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("cache_miss_count");
        generator.write(this.cacheMissCount);
        generator.writeKey("missing_all_fields_count");
        generator.write(this.missingAllFieldsCount);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelInferenceStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failureCount, JsonpDeserializer.longDeserializer(), "failure_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.longDeserializer(), "inference_count");
        op.add(Builder::cacheMissCount, JsonpDeserializer.longDeserializer(), "cache_miss_count");
        op.add(Builder::missingAllFieldsCount, JsonpDeserializer.longDeserializer(), "missing_all_fields_count");
        op.add(Builder::timestamp, Time._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelInferenceStats> {
        private Long failureCount;
        private Long inferenceCount;
        private Long cacheMissCount;
        private Long missingAllFieldsCount;
        private Time timestamp;

        public final Builder failureCount(long value) {
            this.failureCount = value;
            return this;
        }

        public final Builder inferenceCount(long value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder cacheMissCount(long value) {
            this.cacheMissCount = value;
            return this;
        }

        public final Builder missingAllFieldsCount(long value) {
            this.missingAllFieldsCount = value;
            return this;
        }

        public final Builder timestamp(Time value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestamp(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timestamp(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelInferenceStats build() {
            this._checkSingleUse();
            return new TrainedModelInferenceStats(this);
        }
    }
}

