/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.usage;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class NodeUsage
implements JsonpSerializable {
    private final Map<String, Integer> restActions;
    private final String since;
    private final String timestamp;
    private final Map<String, JsonData> aggregations;
    public static final JsonpDeserializer<NodeUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeUsage::setupNodeUsageDeserializer);

    private NodeUsage(Builder builder) {
        this.restActions = ApiTypeHelper.unmodifiableRequired(builder.restActions, (Object)this, "restActions");
        this.since = ApiTypeHelper.requireNonNull(builder.since, this, "since");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.aggregations = ApiTypeHelper.unmodifiableRequired(builder.aggregations, (Object)this, "aggregations");
    }

    public static NodeUsage of(Function<Builder, ObjectBuilder<NodeUsage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Integer> restActions() {
        return this.restActions;
    }

    public final String since() {
        return this.since;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public final Map<String, JsonData> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.restActions)) {
            generator.writeKey("rest_actions");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.restActions.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("since");
        generator.write(this.since);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeUsageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::restActions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "rest_actions");
        op.add(Builder::since, JsonpDeserializer.stringDeserializer(), "since");
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp");
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "aggregations");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeUsage> {
        private Map<String, Integer> restActions;
        private String since;
        private String timestamp;
        private Map<String, JsonData> aggregations;

        public final Builder restActions(Map<String, Integer> map) {
            this.restActions = Builder._mapPutAll(this.restActions, map);
            return this;
        }

        public final Builder restActions(String key, Integer value) {
            this.restActions = Builder._mapPut(this.restActions, key, value);
            return this;
        }

        public final Builder since(String value) {
            this.since = value;
            return this;
        }

        public final Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        public final Builder aggregations(Map<String, JsonData> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, JsonData value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeUsage build() {
            this._checkSingleUse();
            return new NodeUsage(this);
        }
    }
}

