/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.rollup.DeleteJobRequest;
import co.elastic.clients.elasticsearch.rollup.DeleteJobResponse;
import co.elastic.clients.elasticsearch.rollup.GetJobsRequest;
import co.elastic.clients.elasticsearch.rollup.GetJobsResponse;
import co.elastic.clients.elasticsearch.rollup.GetRollupCapsRequest;
import co.elastic.clients.elasticsearch.rollup.GetRollupCapsResponse;
import co.elastic.clients.elasticsearch.rollup.GetRollupIndexCapsRequest;
import co.elastic.clients.elasticsearch.rollup.GetRollupIndexCapsResponse;
import co.elastic.clients.elasticsearch.rollup.PutJobRequest;
import co.elastic.clients.elasticsearch.rollup.PutJobResponse;
import co.elastic.clients.elasticsearch.rollup.RollupRequest;
import co.elastic.clients.elasticsearch.rollup.RollupResponse;
import co.elastic.clients.elasticsearch.rollup.RollupSearchRequest;
import co.elastic.clients.elasticsearch.rollup.RollupSearchResponse;
import co.elastic.clients.elasticsearch.rollup.StartJobRequest;
import co.elastic.clients.elasticsearch.rollup.StartJobResponse;
import co.elastic.clients.elasticsearch.rollup.StopJobRequest;
import co.elastic.clients.elasticsearch.rollup.StopJobResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.EndpointWithResponseMapperAttr;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchRollupAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchRollupAsyncClient> {
    public ElasticsearchRollupAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchRollupAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchRollupAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchRollupAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteJobRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteJobResponse> deleteJob(Function<DeleteJobRequest.Builder, ObjectBuilder<DeleteJobRequest>> fn) {
        return this.deleteJob(fn.apply(new DeleteJobRequest.Builder()).build());
    }

    public CompletableFuture<GetJobsResponse> getJobs(GetJobsRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetJobsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetJobsResponse> getJobs(Function<GetJobsRequest.Builder, ObjectBuilder<GetJobsRequest>> fn) {
        return this.getJobs(fn.apply(new GetJobsRequest.Builder()).build());
    }

    public CompletableFuture<GetJobsResponse> getJobs() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetJobsRequest.Builder().build(), GetJobsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetRollupCapsResponse> getRollupCaps(GetRollupCapsRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetRollupCapsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetRollupCapsResponse> getRollupCaps(Function<GetRollupCapsRequest.Builder, ObjectBuilder<GetRollupCapsRequest>> fn) {
        return this.getRollupCaps(fn.apply(new GetRollupCapsRequest.Builder()).build());
    }

    public CompletableFuture<GetRollupCapsResponse> getRollupCaps() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetRollupCapsRequest.Builder().build(), GetRollupCapsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetRollupIndexCapsResponse> getRollupIndexCaps(GetRollupIndexCapsRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetRollupIndexCapsRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetRollupIndexCapsResponse> getRollupIndexCaps(Function<GetRollupIndexCapsRequest.Builder, ObjectBuilder<GetRollupIndexCapsRequest>> fn) {
        return this.getRollupIndexCaps(fn.apply(new GetRollupIndexCapsRequest.Builder()).build());
    }

    public CompletableFuture<PutJobResponse> putJob(PutJobRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)PutJobRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutJobResponse> putJob(Function<PutJobRequest.Builder, ObjectBuilder<PutJobRequest>> fn) {
        return this.putJob(fn.apply(new PutJobRequest.Builder()).build());
    }

    public CompletableFuture<RollupResponse> rollup(RollupRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)RollupRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<RollupResponse> rollup(Function<RollupRequest.Builder, ObjectBuilder<RollupRequest>> fn) {
        return this.rollup(fn.apply(new RollupRequest.Builder()).build());
    }

    public <TDocument> CompletableFuture<RollupSearchResponse<TDocument>> rollupSearch(RollupSearchRequest request, Class<TDocument> tDocumentClass) {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = RollupSearchRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:rollup.rollup_search.TDocument", this.getDeserializer(tDocumentClass));
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<RollupSearchResponse<TDocument>> rollupSearch(Function<RollupSearchRequest.Builder, ObjectBuilder<RollupSearchRequest>> fn, Class<TDocument> tDocumentClass) {
        return this.rollupSearch(fn.apply(new RollupSearchRequest.Builder()).build(), tDocumentClass);
    }

    public CompletableFuture<StartJobResponse> startJob(StartJobRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)StartJobRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<StartJobResponse> startJob(Function<StartJobRequest.Builder, ObjectBuilder<StartJobRequest>> fn) {
        return this.startJob(fn.apply(new StartJobRequest.Builder()).build());
    }

    public CompletableFuture<StopJobResponse> stopJob(StopJobRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)StopJobRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<StopJobResponse> stopJob(Function<StopJobRequest.Builder, ObjectBuilder<StopJobRequest>> fn) {
        return this.stopJob(fn.apply(new StopJobRequest.Builder()).build());
    }
}

