/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.GetTransformResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetTransformRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean excludeGenerated;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    private final List<String> transformId;
    public static final Endpoint<GetTransformRequest, GetTransformResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTransformRequest, GetTransformResponse>("es/transform.get_transform", request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.transformId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTransformResponse._DESERIALIZER);

    private GetTransformRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.excludeGenerated = builder.excludeGenerated;
        this.from = builder.from;
        this.size = builder.size;
        this.transformId = ApiTypeHelper.unmodifiable(builder.transformId);
    }

    public static GetTransformRequest of(Function<Builder, ObjectBuilder<GetTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<String> transformId() {
        return this.transformId;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetTransformRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean excludeGenerated;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private List<String> transformId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder transformId(List<String> list) {
            this.transformId = Builder._listAddAll(this.transformId, list);
            return this;
        }

        public final Builder transformId(String value, String ... values) {
            this.transformId = Builder._listAdd(this.transformId, value, values);
            return this;
        }

        @Override
        public GetTransformRequest build() {
            this._checkSingleUse();
            return new GetTransformRequest(this);
        }
    }
}

