/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.HttpInputRequestDefinition;
import co.elastic.clients.elasticsearch.watcher.Input;
import co.elastic.clients.elasticsearch.watcher.InputVariant;
import co.elastic.clients.elasticsearch.watcher.ResponseContentType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HttpInput
implements InputVariant,
JsonpSerializable {
    @Nullable
    private final HttpInput http;
    private final List<String> extract;
    @Nullable
    private final HttpInputRequestDefinition request;
    @Nullable
    private final ResponseContentType responseContentType;
    public static final JsonpDeserializer<HttpInput> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInput::setupHttpInputDeserializer);

    private HttpInput(Builder builder) {
        this.http = builder.http;
        this.extract = ApiTypeHelper.unmodifiable(builder.extract);
        this.request = builder.request;
        this.responseContentType = builder.responseContentType;
    }

    public static HttpInput of(Function<Builder, ObjectBuilder<HttpInput>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Input.Kind _inputKind() {
        return Input.Kind.Http;
    }

    @Nullable
    public final HttpInput http() {
        return this.http;
    }

    public final List<String> extract() {
        return this.extract;
    }

    @Nullable
    public final HttpInputRequestDefinition request() {
        return this.request;
    }

    @Nullable
    public final ResponseContentType responseContentType() {
        return this.responseContentType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.extract)) {
            generator.writeKey("extract");
            generator.writeStartArray();
            for (String item0 : this.extract) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (this.responseContentType != null) {
            generator.writeKey("response_content_type");
            this.responseContentType.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHttpInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::http, _DESERIALIZER, "http");
        op.add(Builder::extract, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "extract");
        op.add(Builder::request, HttpInputRequestDefinition._DESERIALIZER, "request");
        op.add(Builder::responseContentType, ResponseContentType._DESERIALIZER, "response_content_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpInput> {
        @Nullable
        private HttpInput http;
        @Nullable
        private List<String> extract;
        @Nullable
        private HttpInputRequestDefinition request;
        @Nullable
        private ResponseContentType responseContentType;

        public final Builder http(@Nullable HttpInput value) {
            this.http = value;
            return this;
        }

        public final Builder http(Function<Builder, ObjectBuilder<HttpInput>> fn) {
            return this.http(fn.apply(new Builder()).build());
        }

        public final Builder extract(List<String> list) {
            this.extract = Builder._listAddAll(this.extract, list);
            return this;
        }

        public final Builder extract(String value, String ... values) {
            this.extract = Builder._listAdd(this.extract, value, values);
            return this;
        }

        public final Builder request(@Nullable HttpInputRequestDefinition value) {
            this.request = value;
            return this;
        }

        public final Builder request(Function<HttpInputRequestDefinition.Builder, ObjectBuilder<HttpInputRequestDefinition>> fn) {
            return this.request(fn.apply(new HttpInputRequestDefinition.Builder()).build());
        }

        public final Builder responseContentType(@Nullable ResponseContentType value) {
            this.responseContentType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpInput build() {
            this._checkSingleUse();
            return new HttpInput(this);
        }
    }
}

