/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class VariableWidthHistogramBucket
extends MultiBucketBase {
    private final double min;
    private final double key;
    private final double max;
    @Nullable
    private final String minAsString;
    @Nullable
    private final String keyAsString;
    @Nullable
    private final String maxAsString;
    public static final JsonpDeserializer<VariableWidthHistogramBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VariableWidthHistogramBucket::setupVariableWidthHistogramBucketDeserializer);

    private VariableWidthHistogramBucket(Builder builder) {
        super(builder);
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.minAsString = builder.minAsString;
        this.keyAsString = builder.keyAsString;
        this.maxAsString = builder.maxAsString;
    }

    public static VariableWidthHistogramBucket of(Function<Builder, ObjectBuilder<VariableWidthHistogramBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double min() {
        return this.min;
    }

    public final double key() {
        return this.key;
    }

    public final double max() {
        return this.max;
    }

    @Nullable
    public final String minAsString() {
        return this.minAsString;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Nullable
    public final String maxAsString() {
        return this.maxAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("min");
        generator.write(this.min);
        generator.writeKey("key");
        generator.write(this.key);
        generator.writeKey("max");
        generator.write(this.max);
        if (this.minAsString != null) {
            generator.writeKey("min_as_string");
            generator.write(this.minAsString);
        }
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
        if (this.maxAsString != null) {
            generator.writeKey("max_as_string");
            generator.write(this.maxAsString);
        }
    }

    protected static void setupVariableWidthHistogramBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min");
        op.add(Builder::key, JsonpDeserializer.doubleDeserializer(), "key");
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(Builder::minAsString, JsonpDeserializer.stringDeserializer(), "min_as_string");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
        op.add(Builder::maxAsString, JsonpDeserializer.stringDeserializer(), "max_as_string");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<VariableWidthHistogramBucket> {
        private Double min;
        private Double key;
        private Double max;
        @Nullable
        private String minAsString;
        @Nullable
        private String keyAsString;
        @Nullable
        private String maxAsString;

        public final Builder min(double value) {
            this.min = value;
            return this;
        }

        public final Builder key(double value) {
            this.key = value;
            return this;
        }

        public final Builder max(double value) {
            this.max = value;
            return this;
        }

        public final Builder minAsString(@Nullable String value) {
            this.minAsString = value;
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        public final Builder maxAsString(@Nullable String value) {
            this.maxAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public VariableWidthHistogramBucket build() {
            this._checkSingleUse();
            return new VariableWidthHistogramBucket(this);
        }
    }
}

