/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.get_script_context;

import co.elastic.clients.elasticsearch.core.get_script_context.ContextMethod;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Context
implements JsonpSerializable {
    private final List<ContextMethod> methods;
    private final String name;
    public static final JsonpDeserializer<Context> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Context::setupContextDeserializer);

    private Context(Builder builder) {
        this.methods = ApiTypeHelper.unmodifiableRequired(builder.methods, (Object)this, "methods");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static Context of(Function<Builder, ObjectBuilder<Context>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ContextMethod> methods() {
        return this.methods;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.methods)) {
            generator.writeKey("methods");
            generator.writeStartArray();
            for (ContextMethod item0 : this.methods) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::methods, JsonpDeserializer.arrayDeserializer(ContextMethod._DESERIALIZER), "methods");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Context> {
        private List<ContextMethod> methods;
        private String name;

        public final Builder methods(List<ContextMethod> list) {
            this.methods = Builder._listAddAll(this.methods, list);
            return this;
        }

        public final Builder methods(ContextMethod value, ContextMethod ... values) {
            this.methods = Builder._listAdd(this.methods, value, values);
            return this;
        }

        public final Builder methods(Function<ContextMethod.Builder, ObjectBuilder<ContextMethod>> fn) {
            return this.methods(fn.apply(new ContextMethod.Builder()).build(), new ContextMethod[0]);
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Context build() {
            this._checkSingleUse();
            return new Context(this);
        }
    }
}

