/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.stats.CCSStats;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterIndices;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterNodes;
import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

public abstract class StatsResponseBase
extends NodesResponseBase {
    private final String clusterName;
    private final String clusterUuid;
    private final ClusterIndices indices;
    private final ClusterNodes nodes;
    private final HealthStatus status;
    private final long timestamp;
    private final CCSStats ccs;

    protected StatsResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.clusterUuid = ApiTypeHelper.requireNonNull(builder.clusterUuid, this, "clusterUuid");
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.nodes = ApiTypeHelper.requireNonNull(builder.nodes, this, "nodes");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, (Object)this, "timestamp", 0L);
        this.ccs = ApiTypeHelper.requireNonNull(builder.ccs, this, "ccs");
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clusterUuid() {
        return this.clusterUuid;
    }

    public final ClusterIndices indices() {
        return this.indices;
    }

    public final ClusterNodes nodes() {
        return this.nodes;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    public final CCSStats ccs() {
        return this.ccs;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("indices");
        this.indices.serialize(generator, mapper);
        generator.writeKey("nodes");
        this.nodes.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("ccs");
        this.ccs.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupStatsResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(AbstractBuilder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(AbstractBuilder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid");
        op.add(AbstractBuilder::indices, ClusterIndices._DESERIALIZER, "indices");
        op.add(AbstractBuilder::nodes, ClusterNodes._DESERIALIZER, "nodes");
        op.add(AbstractBuilder::status, HealthStatus._DESERIALIZER, "status");
        op.add(AbstractBuilder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(AbstractBuilder::ccs, CCSStats._DESERIALIZER, "ccs");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends NodesResponseBase.AbstractBuilder<BuilderT> {
        private String clusterName;
        private String clusterUuid;
        private ClusterIndices indices;
        private ClusterNodes nodes;
        private HealthStatus status;
        private Long timestamp;
        private CCSStats ccs;

        public final BuilderT clusterName(String value) {
            this.clusterName = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT clusterUuid(String value) {
            this.clusterUuid = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT indices(ClusterIndices value) {
            this.indices = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT indices(Function<ClusterIndices.Builder, ObjectBuilder<ClusterIndices>> fn) {
            return this.indices(fn.apply(new ClusterIndices.Builder()).build());
        }

        public final BuilderT nodes(ClusterNodes value) {
            this.nodes = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT nodes(Function<ClusterNodes.Builder, ObjectBuilder<ClusterNodes>> fn) {
            return this.nodes(fn.apply(new ClusterNodes.Builder()).build());
        }

        public final BuilderT status(HealthStatus value) {
            this.status = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT timestamp(long value) {
            this.timestamp = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT ccs(CCSStats value) {
            this.ccs = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT ccs(Function<CCSStats.Builder, ObjectBuilder<CCSStats>> fn) {
            return this.ccs(fn.apply(new CCSStats.Builder()).build());
        }
    }
}

