/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.get;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetResult<TDocument>
implements JsonpSerializable {
    private final String index;
    private final Map<String, JsonData> fields;
    private final List<String> ignored;
    private final boolean found;
    private final String id;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final String routing;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final TDocument source;
    @Nullable
    private final Long version;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<GetResult<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> GetResult.createGetResultDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.get.GetResult.TDocument")));

    protected GetResult(AbstractBuilder<TDocument, ?> builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.ignored = ApiTypeHelper.unmodifiable(builder.ignored);
        this.found = ApiTypeHelper.requireNonNull(builder.found, (Object)this, "found", false);
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.primaryTerm = builder.primaryTerm;
        this.routing = builder.routing;
        this.seqNo = builder.seqNo;
        this.source = builder.source;
        this.version = builder.version;
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> GetResult<TDocument> getResultOf(Function<Builder<TDocument>, ObjectBuilder<GetResult<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    public final List<String> ignored() {
        return this.ignored;
    }

    public final boolean found() {
        return this.found;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final TDocument source() {
        return this.source;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.fields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ignored)) {
            generator.writeKey("_ignored");
            generator.writeStartArray();
            for (String string : this.ignored) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("found");
        generator.write(this.found);
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument> JsonpDeserializer<GetResult<TDocument>> createGetResultDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> GetResult.setupGetResultDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupGetResultDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(AbstractBuilder::ignored, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_ignored");
        op.add(AbstractBuilder::found, JsonpDeserializer.booleanDeserializer(), "found");
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(AbstractBuilder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(AbstractBuilder::source, tDocumentDeserializer, "_source");
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version");
    }

    public static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private String index;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private List<String> ignored;
        private Boolean found;
        private String id;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private String routing;
        @Nullable
        private Long seqNo;
        @Nullable
        private TDocument source;
        @Nullable
        private Long version;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final BuilderT index(String value) {
            this.index = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fields(Map<String, JsonData> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, JsonData value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT ignored(List<String> list) {
            this.ignored = AbstractBuilder._listAddAll(this.ignored, list);
            return (BuilderT)this.self();
        }

        public final BuilderT ignored(String value, String ... values) {
            this.ignored = AbstractBuilder._listAdd(this.ignored, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT found(boolean value) {
            this.found = value;
            return (BuilderT)this.self();
        }

        public final BuilderT id(String value) {
            this.id = value;
            return (BuilderT)this.self();
        }

        public final BuilderT primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return (BuilderT)this.self();
        }

        public final BuilderT routing(@Nullable String value) {
            this.routing = value;
            return (BuilderT)this.self();
        }

        public final BuilderT seqNo(@Nullable Long value) {
            this.seqNo = value;
            return (BuilderT)this.self();
        }

        public final BuilderT source(@Nullable TDocument value) {
            this.source = value;
            return (BuilderT)this.self();
        }

        public final BuilderT version(@Nullable Long value) {
            this.version = value;
            return (BuilderT)this.self();
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder<TDocument>
    extends AbstractBuilder<TDocument, Builder<TDocument>>
    implements ObjectBuilder<GetResult<TDocument>> {
        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public GetResult<TDocument> build() {
            this._checkSingleUse();
            return new GetResult(this);
        }
    }
}

