/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketAggregateBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class SignificantTermsAggregateBase<T>
extends MultiBucketAggregateBase<T> {
    @Nullable
    private final Long bgCount;
    @Nullable
    private final Long docCount;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    protected SignificantTermsAggregateBase(AbstractBuilder<T, ?> builder) {
        super(builder);
        this.bgCount = builder.bgCount;
        this.docCount = builder.docCount;
        this.tSerializer = builder.tSerializer;
    }

    @Nullable
    public final Long bgCount() {
        return this.bgCount;
    }

    @Nullable
    public final Long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bgCount != null) {
            generator.writeKey("bg_count");
            generator.write(this.bgCount.longValue());
        }
        if (this.docCount != null) {
            generator.writeKey("doc_count");
            generator.write(this.docCount.longValue());
        }
    }

    protected static <T, BuilderT extends AbstractBuilder<T, BuilderT>> void setupSignificantTermsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<T> tDeserializer) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, tDeserializer);
        op.add(AbstractBuilder::bgCount, JsonpDeserializer.longDeserializer(), "bg_count");
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
    }

    public static abstract class AbstractBuilder<T, BuilderT extends AbstractBuilder<T, BuilderT>>
    extends MultiBucketAggregateBase.AbstractBuilder<T, BuilderT> {
        @Nullable
        private Long bgCount;
        @Nullable
        private Long docCount;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public final BuilderT bgCount(@Nullable Long value) {
            this.bgCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT docCount(@Nullable Long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

