/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.CompositeSubField;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplateVariant;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldFetchFields;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RuntimeField
implements DynamicTemplateVariant,
JsonpSerializable {
    private final Map<String, CompositeSubField> fields;
    private final List<RuntimeFieldFetchFields> fetchFields;
    @Nullable
    private final String format;
    @Nullable
    private final String inputField;
    @Nullable
    private final String targetField;
    @Nullable
    private final String targetIndex;
    @Nullable
    private final Script script;
    private final RuntimeFieldType type;
    public static final JsonpDeserializer<RuntimeField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeField::setupRuntimeFieldDeserializer);

    private RuntimeField(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.fetchFields = ApiTypeHelper.unmodifiable(builder.fetchFields);
        this.format = builder.format;
        this.inputField = builder.inputField;
        this.targetField = builder.targetField;
        this.targetIndex = builder.targetIndex;
        this.script = builder.script;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static RuntimeField of(Function<Builder, ObjectBuilder<RuntimeField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DynamicTemplate.Kind _dynamicTemplateKind() {
        return DynamicTemplate.Kind.Runtime;
    }

    public final Map<String, CompositeSubField> fields() {
        return this.fields;
    }

    public final List<RuntimeFieldFetchFields> fetchFields() {
        return this.fetchFields;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String inputField() {
        return this.inputField;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String targetIndex() {
        return this.targetIndex;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    public final RuntimeFieldType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.fields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((CompositeSubField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fetchFields)) {
            generator.writeKey("fetch_fields");
            generator.writeStartArray();
            for (RuntimeFieldFetchFields runtimeFieldFetchFields : this.fetchFields) {
                runtimeFieldFetchFields.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.inputField != null) {
            generator.writeKey("input_field");
            generator.write(this.inputField);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.targetIndex != null) {
            generator.writeKey("target_index");
            generator.write(this.targetIndex);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRuntimeFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(CompositeSubField._DESERIALIZER), "fields");
        op.add(Builder::fetchFields, JsonpDeserializer.arrayDeserializer(RuntimeFieldFetchFields._DESERIALIZER), "fetch_fields");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::inputField, JsonpDeserializer.stringDeserializer(), "input_field");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::targetIndex, JsonpDeserializer.stringDeserializer(), "target_index");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::type, RuntimeFieldType._DESERIALIZER, "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RuntimeField> {
        @Nullable
        private Map<String, CompositeSubField> fields;
        @Nullable
        private List<RuntimeFieldFetchFields> fetchFields;
        @Nullable
        private String format;
        @Nullable
        private String inputField;
        @Nullable
        private String targetField;
        @Nullable
        private String targetIndex;
        @Nullable
        private Script script;
        private RuntimeFieldType type;

        public final Builder fields(Map<String, CompositeSubField> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, CompositeSubField value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<CompositeSubField.Builder, ObjectBuilder<CompositeSubField>> fn) {
            return this.fields(key, fn.apply(new CompositeSubField.Builder()).build());
        }

        public final Builder fetchFields(List<RuntimeFieldFetchFields> list) {
            this.fetchFields = Builder._listAddAll(this.fetchFields, list);
            return this;
        }

        public final Builder fetchFields(RuntimeFieldFetchFields value, RuntimeFieldFetchFields ... values) {
            this.fetchFields = Builder._listAdd(this.fetchFields, value, values);
            return this;
        }

        public final Builder fetchFields(Function<RuntimeFieldFetchFields.Builder, ObjectBuilder<RuntimeFieldFetchFields>> fn) {
            return this.fetchFields(fn.apply(new RuntimeFieldFetchFields.Builder()).build(), new RuntimeFieldFetchFields[0]);
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder inputField(@Nullable String value) {
            this.inputField = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder targetIndex(@Nullable String value) {
            this.targetIndex = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder type(RuntimeFieldType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeField build() {
            this._checkSingleUse();
            return new RuntimeField(this);
        }
    }
}

