/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.InferenceEndpoint;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.elasticsearch.inference.UpdateInferenceResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateInferenceRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    @Nullable
    private final TaskType taskType;
    private final InferenceEndpoint inferenceConfig;
    public static final JsonpDeserializer<UpdateInferenceRequest> _DESERIALIZER = UpdateInferenceRequest.createUpdateInferenceRequestDeserializer();
    public static final Endpoint<UpdateInferenceRequest, UpdateInferenceResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateInferenceRequest, UpdateInferenceResponse>("es/inference.update", request -> "PUT", request -> {
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            params.put("inferenceId", request.inferenceId);
        }
        if (propsSet == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateInferenceResponse._DESERIALIZER);

    private UpdateInferenceRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.taskType = builder.taskType;
        this.inferenceConfig = ApiTypeHelper.requireNonNull(builder.inferenceConfig, this, "inferenceConfig");
    }

    public static UpdateInferenceRequest of(Function<Builder, ObjectBuilder<UpdateInferenceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final TaskType taskType() {
        return this.taskType;
    }

    public final InferenceEndpoint inferenceConfig() {
        return this.inferenceConfig;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.inferenceConfig.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<UpdateInferenceRequest> createUpdateInferenceRequestDeserializer() {
        JsonpDeserializer<InferenceEndpoint> valueDeserializer = InferenceEndpoint._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().inferenceConfig((InferenceEndpoint)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateInferenceRequest> {
        private String inferenceId;
        @Nullable
        private TaskType taskType;
        private InferenceEndpoint inferenceConfig;

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder taskType(@Nullable TaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder inferenceConfig(InferenceEndpoint value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceEndpoint.Builder, ObjectBuilder<InferenceEndpoint>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceEndpoint.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            InferenceEndpoint value = InferenceEndpoint._DESERIALIZER.deserialize(parser, mapper);
            return this.inferenceConfig(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateInferenceRequest build() {
            this._checkSingleUse();
            return new UpdateInferenceRequest(this);
        }
    }
}

