/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.BulkError;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkDeleteRoleResponse
implements JsonpSerializable {
    private final List<String> deleted;
    private final List<String> notFound;
    @Nullable
    private final BulkError errors;
    public static final JsonpDeserializer<BulkDeleteRoleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkDeleteRoleResponse::setupBulkDeleteRoleResponseDeserializer);

    private BulkDeleteRoleResponse(Builder builder) {
        this.deleted = ApiTypeHelper.unmodifiable(builder.deleted);
        this.notFound = ApiTypeHelper.unmodifiable(builder.notFound);
        this.errors = builder.errors;
    }

    public static BulkDeleteRoleResponse of(Function<Builder, ObjectBuilder<BulkDeleteRoleResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> deleted() {
        return this.deleted;
    }

    public final List<String> notFound() {
        return this.notFound;
    }

    @Nullable
    public final BulkError errors() {
        return this.errors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.deleted)) {
            generator.writeKey("deleted");
            generator.writeStartArray();
            for (String item0 : this.deleted) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.notFound)) {
            generator.writeKey("not_found");
            generator.writeStartArray();
            for (String item0 : this.notFound) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.errors != null) {
            generator.writeKey("errors");
            this.errors.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBulkDeleteRoleResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deleted, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "deleted");
        op.add(Builder::notFound, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "not_found");
        op.add(Builder::errors, BulkError._DESERIALIZER, "errors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BulkDeleteRoleResponse> {
        @Nullable
        private List<String> deleted;
        @Nullable
        private List<String> notFound;
        @Nullable
        private BulkError errors;

        public final Builder deleted(List<String> list) {
            this.deleted = Builder._listAddAll(this.deleted, list);
            return this;
        }

        public final Builder deleted(String value, String ... values) {
            this.deleted = Builder._listAdd(this.deleted, value, values);
            return this;
        }

        public final Builder notFound(List<String> list) {
            this.notFound = Builder._listAddAll(this.notFound, list);
            return this;
        }

        public final Builder notFound(String value, String ... values) {
            this.notFound = Builder._listAdd(this.notFound, value, values);
            return this;
        }

        public final Builder errors(@Nullable BulkError value) {
            this.errors = value;
            return this;
        }

        public final Builder errors(Function<BulkError.Builder, ObjectBuilder<BulkError>> fn) {
            return this.errors(fn.apply(new BulkError.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkDeleteRoleResponse build() {
            this._checkSingleUse();
            return new BulkDeleteRoleResponse(this);
        }
    }
}

