/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.coze;

import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.alibaba.fastjson.JSONPath;
import java.util.List;
import java.util.Map;

public class CozeLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildMessageContent(Message message, Map<String, Object> map) {
            map.put("content_type", "text");
            super.buildMessageContent(message, map);
        }
    };

    public static AiMessageParser getAiMessageParser() {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        aiMessageParser.setContentPath("$.content");
        aiMessageParser.setTotalTokensPath("$.usage.token_count");
        aiMessageParser.setCompletionTokensPath("$.usage.output_count");
        aiMessageParser.setPromptTokensPath("$.usage.input_count");
        aiMessageParser.setStatusParser(content -> {
            Boolean done = (Boolean)JSONPath.eval((Object)content, (String)"$.done");
            if (done != null && done.booleanValue()) {
                return MessageStatus.END;
            }
            return MessageStatus.MIDDLE;
        });
        return aiMessageParser;
    }

    public static String promptToPayload(Prompt prompt, String botId, String userId, Map<String, String> customVariables, boolean stream) {
        List messages = prompt.toMessages();
        return Maps.of().set("bot_id", (Object)botId).set("user_id", (Object)userId).set("auto_save_history", (Object)true).set("additional_messages", promptFormat.toMessagesJsonObject(messages)).set("stream", (Object)stream).setIf(customVariables != null, "custom_variables", customVariables).toJSON();
    }
}

