/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.qwen;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.MessageResponse;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.llm.response.FunctionMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.FunctionMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.FunctionMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.FunctionPrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.qwen.QwenLlmConfig;
import com.agentsflex.llm.qwen.QwenLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;

public class QwenLlm
extends BaseLlm<QwenLlmConfig> {
    HttpClient httpClient = new HttpClient();
    public AiMessageParser aiMessageParser = QwenLlmUtil.getAiMessageParser();
    public FunctionMessageParser functionMessageParser = QwenLlmUtil.getFunctionMessageParser();

    public QwenLlm(QwenLlmConfig config) {
        super((LlmConfig)config);
    }

    public <R extends MessageResponse<?>> R chat(Prompt<R> prompt, ChatOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        String payload = QwenLlmUtil.promptToPayload(prompt, (QwenLlmConfig)this.config, options);
        String endpoint = ((QwenLlmConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/api/v1/services/aigc/text-generation/generation", headers, payload);
        if (StringUtil.noText((String)response)) {
            return null;
        }
        if (((QwenLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        Object messageResponse = prompt instanceof FunctionPrompt ? new FunctionMessageResponse(((FunctionPrompt)prompt).getFunctions(), (FunctionMessage)this.functionMessageParser.parse((Object)jsonObject)) : new AiMessageResponse((AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return (R)messageResponse;
    }

    public <R extends MessageResponse<?>> void chatStream(Prompt<R> prompt, StreamResponseListener<R> listener, ChatOptions options) {
        SseClient llmClient = new SseClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        headers.put("X-DashScope-SSE", "enable");
        String payload = QwenLlmUtil.promptToPayload(prompt, (QwenLlmConfig)this.config, options);
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, listener, prompt, (AiMessageParser)new DefaultAiMessageParser(){
            int prevMessageLength = 0;

            public AiMessage parse(JSONObject content) {
                AiMessage aiMessage = (AiMessage)QwenLlm.this.aiMessageParser.parse((Object)content);
                String messageContent = aiMessage.getContent();
                aiMessage.setContent(messageContent.substring(this.prevMessageLength));
                this.prevMessageLength = messageContent.length();
                return aiMessage;
            }
        }, this.functionMessageParser);
        String endpoint = ((QwenLlmConfig)this.config).getEndpoint();
        llmClient.start(endpoint + "/api/v1/services/aigc/text-generation/generation", headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public VectorData embed(Document document, EmbeddingOptions options) {
        String payload = QwenLlmUtil.promptToEnabledPayload(document, options, (QwenLlmConfig)this.config);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + ((QwenLlmConfig)this.getConfig()).getApiKey());
        String response = this.httpClient.post(QwenLlmUtil.createEmbedURL((QwenLlmConfig)this.config), headers, payload);
        if (StringUtil.noText((String)response)) {
            return null;
        }
        if (((QwenLlmConfig)this.config).isDebug()) {
            System.out.println(">>>>receive payload:" + response);
        }
        VectorData vectorData = new VectorData();
        Object verctor = JSONPath.read((String)response, (String)"$.output.embeddings[0].embedding");
        double[] vers = (double[])JSON.parseObject((String)JSON.toJSONString((Object)verctor), double[].class);
        vectorData.setVector(vers);
        return vectorData;
    }
}

