/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.store.milvus;

import com.agentsflex.core.store.condition.Condition;
import com.agentsflex.core.store.condition.ConditionType;
import com.agentsflex.core.store.condition.ExpressionAdaptor;
import com.agentsflex.core.store.condition.Value;
import java.util.StringJoiner;

public class MilvusExpressionAdaptor
implements ExpressionAdaptor {
    public static final MilvusExpressionAdaptor DEFAULT = new MilvusExpressionAdaptor();

    public String toOperationSymbol(ConditionType type) {
        if (type == ConditionType.EQ) {
            return " == ";
        }
        return type.getDefaultSymbol();
    }

    public String toCondition(Condition condition) {
        if (condition.getType() == ConditionType.BETWEEN) {
            Object[] values = (Object[])((Value)condition.getRight()).getValue();
            return "(" + this.toLeft(condition.getLeft()) + this.toOperationSymbol(ConditionType.GE) + values[0] + " && " + this.toLeft(condition.getLeft()) + this.toOperationSymbol(ConditionType.LE) + values[1] + ")";
        }
        return super.toCondition(condition);
    }

    public String toValue(Condition condition, Object value) {
        if (condition.getType() == ConditionType.IN) {
            Object[] values = (Object[])value;
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            for (Object v : values) {
                if (v == null) continue;
                stringJoiner.add("\"" + v + "\"");
            }
            return stringJoiner.toString();
        }
        return super.toValue(condition, value);
    }
}

