/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.executor;

import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.core.context.RemoteRetryContext;
import com.aizuda.snailjob.client.core.intercepter.RetrySiteSnapshot;
import com.aizuda.snailjob.client.core.log.RetryLogMeta;
import com.aizuda.snailjob.client.core.retryer.RetryerResultContext;
import com.aizuda.snailjob.client.core.strategy.RetryStrategy;
import com.aizuda.snailjob.common.core.enums.RetryResultStatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.model.dto.DispatchRetryResultDTO;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RemoteRetryExecutor {
    private final RetryStrategy remoteRetryStrategies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatchRetryResultDTO doRetry(RemoteRetryContext context) {
        DispatchRetryResultDTO executeRespDto = new DispatchRetryResultDTO();
        executeRespDto.setRetryId(context.getRetryId());
        executeRespDto.setRetryTaskId(context.getRetryTaskId());
        executeRespDto.setNamespaceId(context.getNamespaceId());
        executeRespDto.setGroupName(context.getGroupName());
        executeRespDto.setSceneName(context.getScene());
        try {
            RemoteRetryExecutor.initLogContext(context);
            RetryerResultContext retryerResultContext = this.remoteRetryStrategies.openRetry(context.getScene(), context.getExecutorName(), context.getDeSerialize());
            if (RetrySiteSnapshot.isRetryForStatusCode()) {
                executeRespDto.setStatusCode(RetryResultStatusEnum.STOP.getStatus());
                executeRespDto.setExceptionMsg("Downstream marks no need for retry");
            } else {
                RetryResultStatusEnum retryResultStatusEnum = retryerResultContext.getRetryResultStatusEnum();
                if (Objects.isNull(retryResultStatusEnum)) {
                    retryResultStatusEnum = RetryResultStatusEnum.STOP;
                    retryerResultContext.setMessage("No retry status obtained. Task stopped");
                }
                executeRespDto.setStatusCode(retryResultStatusEnum.getStatus());
                executeRespDto.setExceptionMsg(retryerResultContext.getMessage());
            }
            if (Objects.nonNull(retryerResultContext.getResult())) {
                executeRespDto.setResultJson(JsonUtil.toJsonString((Object)retryerResultContext.getResult()));
            }
            Integer retryCount = context.getRetryCount() + 1;
            if (Objects.equals(RetryResultStatusEnum.SUCCESS.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.info("remote retry\u3010SUCCESS\u3011. retryTaskId:[{}] count:[{}] result:[{}]", new Object[]{context.getRetryTaskId(), retryCount, executeRespDto.getResultJson()});
            } else if (Objects.equals(RetryResultStatusEnum.STOP.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.warn("remote retry \u3010STOP\u3011.retryTaskId:[{}] count:[{}]  exceptionMsg:[{}]", new Object[]{context.getRetryTaskId(), retryCount, executeRespDto.getExceptionMsg()});
            } else if (Objects.equals(RetryResultStatusEnum.FAILURE.getStatus(), executeRespDto.getStatusCode())) {
                SnailJobLog.REMOTE.error("remote retry \u3010FAILURE\u3011. retryTaskId:[{}] count:[{}] ", new Object[]{context.getRetryTaskId(), retryCount, retryerResultContext.getThrowable()});
            } else {
                SnailJobLog.REMOTE.error("remote retry \u3010UNKNOWN\u3011. retryTaskId:[{}] count:[{}] result:[{}]", new Object[]{context.getRetryTaskId(), retryCount, executeRespDto.getResultJson(), retryerResultContext.getThrowable()});
            }
        }
        finally {
            RetrySiteSnapshot.removeAll();
            SnailJobLogManager.removeAll();
        }
        return executeRespDto;
    }

    private static void initLogContext(RemoteRetryContext context) {
        RetryLogMeta retryLogMeta = new RetryLogMeta();
        retryLogMeta.setGroupName(context.getGroupName());
        retryLogMeta.setNamespaceId(context.getNamespaceId());
        retryLogMeta.setRetryId(context.getRetryId());
        retryLogMeta.setRetryTaskId(context.getRetryTaskId());
        SnailJobLogManager.initLogInfo((LogMeta)retryLogMeta, (LogTypeEnum)LogTypeEnum.RETRY);
    }

    @Generated
    public RemoteRetryExecutor(RetryStrategy remoteRetryStrategies) {
        this.remoteRetryStrategies = remoteRetryStrategies;
    }
}

