/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.report;

import com.aizuda.snailjob.client.common.RpcClient;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.core.RetryExecutorParameter;
import com.aizuda.snailjob.client.core.executor.GuavaRetryExecutor;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.RetryNotifySceneEnum;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.core.window.Listener;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.ConfigRequest;
import com.aizuda.snailjob.model.request.RetryTaskRequest;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportListener
implements Listener<RetryTaskRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportListener.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String reportErrorTextMessageFormatter = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u5f02\u6b65\u6279\u91cf\u4e0a\u62a5\u5f02\u5e38</font>  \n> IP:{}  \n> \u7a7a\u95f4ID:{}  \n> \u540d\u79f0:{}  \n> \u65f6\u95f4:{}  \n> \u5f02\u5e38:{}  \n";
    private static final RpcClient CLIENT = (RpcClient)RequestBuilder.newBuilder().client(RpcClient.class).callback(nettyResult -> SnailJobLog.LOCAL.info("Data report successfully requestId:[{}]", new Object[]{nettyResult.getReqId()})).build();

    public void handler(List<RetryTaskRequest> list) {
        GuavaRetryExecutor retryExecutor = new GuavaRetryExecutor();
        Retryer retryer = retryExecutor.build(this.getRetryExecutorParameter());
        try {
            retryExecutor.call(retryer, () -> {
                SnailJobLog.LOCAL.info("Batch asynchronous reporting ... <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)});
                CLIENT.reportRetryInfo(list);
                return null;
            }, throwable -> {
                SnailJobLog.LOCAL.error("Data report failed. <|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)});
                this.sendMessage((Throwable)throwable);
            }, o -> SnailJobLog.LOCAL.info("Data report successful retry\uff1a<|>{}<|>", new Object[]{JsonUtil.toJsonString((Object)list)}));
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Data report failed. <|>{}<|>", new Object[]{JsonUtil.toJsonString(list), e});
        }
    }

    public RetryExecutorParameter<WaitStrategy, StopStrategy> getRetryExecutorParameter() {
        return new RetryExecutorParameter<WaitStrategy, StopStrategy>(){

            @Override
            public WaitStrategy backOff() {
                return WaitStrategies.fixedWait((long)2L, (TimeUnit)TimeUnit.SECONDS);
            }

            @Override
            public StopStrategy stop() {
                return StopStrategies.stopAfterAttempt((int)10);
            }

            @Override
            public List<RetryListener> getRetryListeners() {
                return Collections.singletonList(new RetryListener(){

                    public <V> void onRetry(Attempt<V> attempt) {
                        if (attempt.hasException()) {
                            SnailJobLog.LOCAL.error(" SnailJob reports an exception when reporting abnormal data, attempt [{}]", new Object[]{attempt.getAttemptNumber(), attempt.getExceptionCause()});
                        }
                    }
                });
            }
        };
    }

    private void sendMessage(Throwable e) {
        try {
            ConfigRequest.Notify notify = GroupVersionCache.getRetryNotifyAttribute((Integer)RetryNotifySceneEnum.CLIENT_REPORT_ERROR.getNotifyScene());
            if (Objects.isNull(notify)) {
                return;
            }
            SnailJobProperties properties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
            if (Objects.isNull(properties)) {
                return;
            }
            List recipients = Optional.ofNullable(notify.getRecipients()).orElse(Lists.newArrayList());
            for (ConfigRequest.Notify.Recipient recipient : recipients) {
                AlarmContext context = AlarmContext.build().text(reportErrorTextMessageFormatter, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), properties.getNamespace(), properties.getGroup(), LocalDateTime.now().format(formatter), e.getMessage()}).title("Reporting exception: [{}]", new Object[]{properties.getGroup()}).notifyAttribute(recipient.getNotifyAttribute());
                Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipient.getNotifyType())).ifPresent(alarm -> alarm.asyncSendMessage((Object)context));
            }
        }
        catch (Exception e1) {
            SnailJobLog.LOCAL.error("Client failed to send component exception alarm", new Object[]{e1});
        }
    }
}

