/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.GraphResponse;
import com.alibaba.cloud.ai.graph.KeyStrategy;
import com.alibaba.cloud.ai.graph.KeyStrategyFactory;
import com.alibaba.cloud.ai.graph.NodeOutput;
import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.SubGraphNode;
import com.alibaba.cloud.ai.graph.action.AsyncEdgeAction;
import com.alibaba.cloud.ai.graph.action.AsyncNodeActionWithConfig;
import com.alibaba.cloud.ai.graph.action.EdgeAction;
import com.alibaba.cloud.ai.graph.action.NodeActionWithConfig;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.agent.Builder;
import com.alibaba.cloud.ai.graph.agent.factory.AgentBuilderFactory;
import com.alibaba.cloud.ai.graph.agent.factory.DefaultAgentBuilderFactory;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.JumpTo;
import com.alibaba.cloud.ai.graph.agent.hook.ModelHook;
import com.alibaba.cloud.ai.graph.agent.hook.ToolInjection;
import com.alibaba.cloud.ai.graph.agent.hook.hip.HumanInTheLoopHook;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import com.alibaba.cloud.ai.graph.agent.node.AgentLlmNode;
import com.alibaba.cloud.ai.graph.agent.node.AgentToolNode;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.internal.node.Node;
import com.alibaba.cloud.ai.graph.serializer.AgentInstructionMessage;
import com.alibaba.cloud.ai.graph.state.strategy.AppendStrategy;
import com.alibaba.cloud.ai.graph.state.strategy.ReplaceStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class ReactAgent
extends BaseAgent {
    Logger logger = LoggerFactory.getLogger(ReactAgent.class);
    private final AgentLlmNode llmNode;
    private final AgentToolNode toolNode;
    private CompiledGraph compiledGraph;
    private List<? extends Hook> hooks;
    private List<ModelInterceptor> modelInterceptors;
    private List<ToolInterceptor> toolInterceptors;
    private String instruction;

    public ReactAgent(AgentLlmNode llmNode, AgentToolNode toolNode, CompileConfig compileConfig, Builder builder) {
        super(builder.name, builder.description, builder.includeContents, builder.returnReasoningContents, builder.outputKey, builder.outputKeyStrategy);
        this.instruction = builder.instruction;
        this.llmNode = llmNode;
        this.toolNode = toolNode;
        this.compileConfig = compileConfig;
        this.hooks = builder.hooks;
        this.modelInterceptors = builder.modelInterceptors;
        this.toolInterceptors = builder.toolInterceptors;
        this.includeContents = builder.includeContents;
        this.inputSchema = builder.inputSchema;
        this.inputType = builder.inputType;
        this.outputSchema = builder.outputSchema;
        this.outputType = builder.outputType;
        if (this.modelInterceptors != null && !this.modelInterceptors.isEmpty()) {
            this.llmNode.setModelInterceptors(this.modelInterceptors);
        }
        if (this.toolInterceptors != null && !this.toolInterceptors.isEmpty()) {
            this.toolNode.setToolInterceptors(this.toolInterceptors);
        }
    }

    public static Builder builder() {
        return new DefaultAgentBuilderFactory().builder();
    }

    public static Builder builder(AgentBuilderFactory agentBuilderFactory) {
        return agentBuilderFactory.builder();
    }

    public AssistantMessage call(String message) throws GraphRunnerException {
        return this.doMessageInvoke(message, null);
    }

    public AssistantMessage call(String message, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(message, config);
    }

    public AssistantMessage call(UserMessage message) throws GraphRunnerException {
        return this.doMessageInvoke(message, null);
    }

    public AssistantMessage call(UserMessage message, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(message, config);
    }

    public AssistantMessage call(List<Message> messages) throws GraphRunnerException {
        return this.doMessageInvoke(messages, null);
    }

    public AssistantMessage call(List<Message> messages, RunnableConfig config) throws GraphRunnerException {
        return this.doMessageInvoke(messages, config);
    }

    private AssistantMessage doMessageInvoke(Object message, RunnableConfig config) throws GraphRunnerException {
        Map<String, Object> inputs = this.buildMessageInput(message);
        Optional<OverAllState> state = this.doInvoke(inputs, config);
        if (StringUtils.hasLength((String)this.outputKey)) {
            return state.flatMap(s -> s.value(this.outputKey)).map(msg -> (AssistantMessage)msg).orElseThrow(() -> new IllegalStateException("Output key " + this.outputKey + " not found in agent state"));
        }
        return state.flatMap(s -> s.value("messages")).map(messageList -> (List)messageList).stream().flatMap(messageList -> messageList.stream()).filter(msg -> msg instanceof AssistantMessage).map(msg -> (AssistantMessage)msg).reduce((first, second) -> second).orElseThrow(() -> new IllegalStateException("No AssistantMessage found in 'messages' state"));
    }

    public StateGraph getStateGraph() {
        return this.graph;
    }

    public CompiledGraph getCompiledGraph() {
        return this.compiledGraph;
    }

    @Override
    public Node asNode(boolean includeContents, boolean returnReasoningContents, String outputKeyToParent) {
        if (this.compiledGraph == null) {
            this.compiledGraph = this.getAndCompileGraph();
        }
        return new AgentSubGraphNode(this.name, includeContents, returnReasoningContents, outputKeyToParent, this.compiledGraph, this.instruction);
    }

    @Override
    protected StateGraph initGraph() throws GraphStateException {
        ModelHook modelHook;
        AgentHook agentHook;
        if (this.hooks == null) {
            this.hooks = new ArrayList<Hook>();
        }
        HashSet<String> hookNames = new HashSet<String>();
        for (Hook hook : this.hooks) {
            if (!hookNames.add(hook.getName())) {
                throw new IllegalArgumentException("Duplicate hook instances found");
            }
            hook.setAgentName(this.name);
        }
        StateGraph graph = new StateGraph(this.name, this.buildMessagesKeyStrategyFactory(this.hooks));
        graph.addNode("model", AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)this.llmNode));
        graph.addNode("tool", AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)this.toolNode));
        this.setupToolsForHooks(this.hooks, this.toolNode);
        List<Hook> list = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.BEFORE_AGENT);
        List<Hook> afterAgentHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.AFTER_AGENT);
        List<Hook> beforeModelHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.BEFORE_MODEL);
        List<Hook> afterModelHooks = ReactAgent.filterHooksByPosition(this.hooks, HookPosition.AFTER_MODEL);
        for (Hook hook : list) {
            if (!(hook instanceof AgentHook)) continue;
            agentHook = (AgentHook)hook;
            graph.addNode(hook.getName() + ".before", agentHook::beforeAgent);
        }
        for (Hook hook : afterAgentHooks) {
            if (!(hook instanceof AgentHook)) continue;
            agentHook = (AgentHook)hook;
            graph.addNode(hook.getName() + ".after", agentHook::afterAgent);
        }
        for (Hook hook : beforeModelHooks) {
            if (!(hook instanceof ModelHook)) continue;
            modelHook = (ModelHook)hook;
            graph.addNode(hook.getName() + ".beforeModel", modelHook::beforeModel);
        }
        for (Hook hook : afterModelHooks) {
            if (!(hook instanceof ModelHook)) continue;
            modelHook = (ModelHook)hook;
            if (hook instanceof HumanInTheLoopHook) {
                HumanInTheLoopHook humanInTheLoopHook = (HumanInTheLoopHook)hook;
                graph.addNode(hook.getName() + ".afterModel", (AsyncNodeActionWithConfig)humanInTheLoopHook);
                continue;
            }
            graph.addNode(hook.getName() + ".afterModel", modelHook::afterModel);
        }
        String entryNode = ReactAgent.determineEntryNode(list, beforeModelHooks);
        String loopEntryNode = ReactAgent.determineLoopEntryNode(beforeModelHooks);
        String loopExitNode = ReactAgent.determineLoopExitNode(afterModelHooks);
        String exitNode = ReactAgent.determineExitNode(afterAgentHooks);
        graph.addEdge("__START__", entryNode);
        ReactAgent.setupHookEdges(graph, list, afterAgentHooks, beforeModelHooks, afterModelHooks, entryNode, loopEntryNode, loopExitNode, exitNode, true, this);
        return graph;
    }

    private void setupToolsForHooks(List<? extends Hook> hooks, AgentToolNode toolNode) {
        if (hooks == null || hooks.isEmpty() || toolNode == null) {
            return;
        }
        List<ToolCallback> availableTools = toolNode.getToolCallbacks();
        if (availableTools == null || availableTools.isEmpty()) {
            return;
        }
        for (Hook hook : hooks) {
            ToolInjection toolInjection;
            ToolCallback toolToInject;
            if (!(hook instanceof ToolInjection) || (toolToInject = this.findToolForHook(toolInjection = (ToolInjection)((Object)hook), availableTools)) == null) continue;
            toolInjection.injectTool(toolToInject);
        }
    }

    private ToolCallback findToolForHook(ToolInjection toolInjection, List<ToolCallback> availableTools) {
        String requiredToolName = toolInjection.getRequiredToolName();
        Class<? extends ToolCallback> requiredToolType = toolInjection.getRequiredToolType();
        if (requiredToolName != null) {
            for (ToolCallback tool : availableTools) {
                String toolName = tool.getToolDefinition().name();
                if (!requiredToolName.equals(toolName)) continue;
                return tool;
            }
        }
        if (requiredToolType != null) {
            for (ToolCallback tool : availableTools) {
                if (!requiredToolType.isInstance(tool)) continue;
                return tool;
            }
        }
        if (requiredToolName == null && requiredToolType == null && !availableTools.isEmpty()) {
            return availableTools.get(0);
        }
        return null;
    }

    private static List<Hook> filterHooksByPosition(List<? extends Hook> hooks, HookPosition position) {
        return hooks.stream().filter(hook -> {
            HookPosition[] positions = hook.getHookPositions();
            return Arrays.asList(positions).contains((Object)position);
        }).collect(Collectors.toList());
    }

    private static String determineEntryNode(List<Hook> agentHooks, List<Hook> modelHooks) {
        if (!agentHooks.isEmpty()) {
            return agentHooks.get(0).getName() + ".before";
        }
        if (!modelHooks.isEmpty()) {
            return modelHooks.get(0).getName() + ".beforeModel";
        }
        return "model";
    }

    private static String determineLoopEntryNode(List<Hook> modelHooks) {
        if (!modelHooks.isEmpty()) {
            return modelHooks.get(0).getName() + ".beforeModel";
        }
        return "model";
    }

    private static String determineLoopExitNode(List<Hook> modelHooks) {
        if (!modelHooks.isEmpty()) {
            return modelHooks.get(0).getName() + ".afterModel";
        }
        return "model";
    }

    private static String determineExitNode(List<Hook> agentHooks) {
        if (!agentHooks.isEmpty()) {
            return agentHooks.get(agentHooks.size() - 1).getName() + ".after";
        }
        return "__END__";
    }

    private static void setupHookEdges(StateGraph graph, List<Hook> beforeAgentHooks, List<Hook> afterAgentHooks, List<Hook> beforeModelHooks, List<Hook> afterModelHooks, String entryNode, String loopEntryNode, String loopExitNode, String exitNode, boolean hasTools, ReactAgent agentInstance) throws GraphStateException {
        ReactAgent.chainHook(graph, beforeAgentHooks, ".before", loopEntryNode, loopEntryNode, exitNode);
        ReactAgent.chainHook(graph, beforeModelHooks, ".beforeModel", "model", loopEntryNode, exitNode);
        if (!afterModelHooks.isEmpty()) {
            ReactAgent.chainModelHookReverse(graph, afterModelHooks, ".afterModel", "model", loopEntryNode, exitNode);
        }
        if (!afterAgentHooks.isEmpty()) {
            ReactAgent.chainAgentHookReverse(graph, afterAgentHooks, ".after", exitNode, loopEntryNode, exitNode);
        }
        if (hasTools) {
            ReactAgent.setupToolRouting(graph, loopExitNode, loopEntryNode, exitNode, agentInstance);
        } else if (!loopExitNode.equals("model")) {
            ReactAgent.addHookEdge(graph, loopExitNode, exitNode, loopEntryNode, exitNode, afterModelHooks.get(afterModelHooks.size() - 1).canJumpTo());
        } else {
            graph.addEdge(loopExitNode, exitNode);
        }
    }

    private static void chainModelHookReverse(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        graph.addEdge(defaultNext, hooks.get(hooks.size() - 1).getName() + nameSuffix);
        for (int i = hooks.size() - 1; i > 0; --i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i - 1);
            ReactAgent.addHookEdge(graph, m1.getName() + nameSuffix, m2.getName() + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
    }

    private static void chainAgentHookReverse(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        if (!hooks.isEmpty()) {
            Hook last = hooks.get(hooks.size() - 1);
            ReactAgent.addHookEdge(graph, defaultNext, "__END__", modelDestination, endDestination, last.canJumpTo());
        }
        for (int i = hooks.size() - 1; i > 0; --i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i - 1);
            ReactAgent.addHookEdge(graph, m1.getName() + nameSuffix, m2.getName() + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
    }

    private static void chainHook(StateGraph graph, List<Hook> hooks, String nameSuffix, String defaultNext, String modelDestination, String endDestination) throws GraphStateException {
        for (int i = 0; i < hooks.size() - 1; ++i) {
            Hook m1 = hooks.get(i);
            Hook m2 = hooks.get(i + 1);
            ReactAgent.addHookEdge(graph, m1.getName() + nameSuffix, m2.getName() + nameSuffix, modelDestination, endDestination, m1.canJumpTo());
        }
        if (!hooks.isEmpty()) {
            Hook last = hooks.get(hooks.size() - 1);
            ReactAgent.addHookEdge(graph, last.getName() + nameSuffix, defaultNext, modelDestination, endDestination, last.canJumpTo());
        }
    }

    private static void addHookEdge(StateGraph graph, String name, String defaultDestination, String modelDestination, String endDestination, List<JumpTo> canJumpTo) throws GraphStateException {
        if (canJumpTo != null && !canJumpTo.isEmpty()) {
            EdgeAction router = state -> {
                JumpTo jumpTo = state.value("jump_to").orElse(null);
                return ReactAgent.resolveJump(jumpTo, modelDestination, endDestination, defaultDestination);
            };
            HashMap<String, String> destinations = new HashMap<String, String>();
            destinations.put(defaultDestination, defaultDestination);
            if (canJumpTo.contains((Object)JumpTo.end)) {
                destinations.put(endDestination, endDestination);
            }
            if (canJumpTo.contains((Object)JumpTo.tool)) {
                destinations.put("tool", "tool");
            }
            if (canJumpTo.contains((Object)JumpTo.model) && !name.equals(modelDestination)) {
                destinations.put(modelDestination, modelDestination);
            }
            graph.addConditionalEdges(name, AsyncEdgeAction.edge_async((EdgeAction)router), destinations);
        } else {
            graph.addEdge(name, defaultDestination);
        }
    }

    private static void setupToolRouting(StateGraph graph, String loopExitNode, String loopEntryNode, String exitNode, ReactAgent agentInstance) throws GraphStateException {
        graph.addConditionalEdges(loopExitNode, AsyncEdgeAction.edge_async((EdgeAction)agentInstance.makeModelToTools(loopEntryNode, exitNode)), Map.of("tool", "tool", exitNode, exitNode, loopEntryNode, loopEntryNode));
        graph.addConditionalEdges("tool", AsyncEdgeAction.edge_async((EdgeAction)agentInstance.makeToolsToModelEdge(loopEntryNode, exitNode)), Map.of(loopEntryNode, loopEntryNode, exitNode, exitNode));
    }

    private static String resolveJump(JumpTo jumpTo, String modelDestination, String endDestination, String defaultDestination) {
        if (jumpTo == null) {
            return defaultDestination;
        }
        return switch (jumpTo) {
            default -> throw new IncompatibleClassChangeError();
            case JumpTo.model -> modelDestination;
            case JumpTo.end -> endDestination;
            case JumpTo.tool -> "tool";
        };
    }

    private KeyStrategyFactory buildMessagesKeyStrategyFactory(List<? extends Hook> hooks) {
        return () -> {
            HashMap<String, Object> keyStrategyHashMap = new HashMap<String, Object>();
            if (this.outputKey != null && !this.outputKey.isEmpty()) {
                keyStrategyHashMap.put(this.outputKey, this.outputKeyStrategy == null ? new ReplaceStrategy() : this.outputKeyStrategy);
            }
            keyStrategyHashMap.put("messages", new AppendStrategy());
            if (hooks != null) {
                for (Hook hook : hooks) {
                    Map<String, KeyStrategy> hookStrategies = hook.getKeyStrategys();
                    if (hookStrategies == null || hookStrategies.isEmpty()) continue;
                    keyStrategyHashMap.putAll(hookStrategies);
                }
            }
            return keyStrategyHashMap;
        };
    }

    private EdgeAction makeModelToTools(String modelDestination, String endDestination) {
        return state -> {
            List messages = state.value("messages").orElse(List.of());
            if (messages.isEmpty()) {
                this.logger.warn("No messages found in state when routing from model to tools");
                return endDestination;
            }
            Message lastMessage = (Message)messages.get(messages.size() - 1);
            if (lastMessage instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)lastMessage;
                if (assistantMessage.hasToolCalls()) {
                    return "tool";
                }
                return endDestination;
            }
            if (lastMessage instanceof ToolResponseMessage) {
                if (messages.size() < 2) {
                    throw new RuntimeException("Less than 2 messages in state when last message is ToolResponseMessage");
                }
                Message secondLastMessage = (Message)messages.get(messages.size() - 2);
                if (secondLastMessage instanceof AssistantMessage) {
                    AssistantMessage assistantMessage = (AssistantMessage)secondLastMessage;
                    ToolResponseMessage toolResponseMessage = (ToolResponseMessage)lastMessage;
                    if (assistantMessage.hasToolCalls()) {
                        Set requestedToolNames = assistantMessage.getToolCalls().stream().map(toolCall -> toolCall.name()).collect(Collectors.toSet());
                        Set executedToolNames = toolResponseMessage.getResponses().stream().map(response -> response.name()).collect(Collectors.toSet());
                        if (executedToolNames.containsAll(requestedToolNames)) {
                            return modelDestination;
                        }
                        return "tool";
                    }
                }
            }
            return endDestination;
        };
    }

    private EdgeAction makeToolsToModelEdge(String modelDestination, String endDestination) {
        return state -> {
            boolean allReturnDirect;
            ToolResponseMessage toolResponseMessage = this.fetchLastToolResponseMessage(state);
            if (toolResponseMessage != null && !toolResponseMessage.getResponses().isEmpty() && (allReturnDirect = toolResponseMessage.getResponses().stream().allMatch(toolResponse -> {
                String toolName = toolResponse.name();
                return false;
            }))) {
                return endDestination;
            }
            return modelDestination;
        };
    }

    private ToolResponseMessage fetchLastToolResponseMessage(OverAllState state) {
        List messages = state.value("messages").orElse(List.of());
        ToolResponseMessage toolResponseMessage = null;
        for (int i = messages.size() - 1; i >= 0; --i) {
            if (!(messages.get(i) instanceof ToolResponseMessage)) continue;
            toolResponseMessage = (ToolResponseMessage)messages.get(i);
            break;
        }
        return toolResponseMessage;
    }

    public String instruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
        this.llmNode.setInstruction(instruction);
    }

    @Override
    public KeyStrategy getOutputKeyStrategy() {
        return this.outputKeyStrategy;
    }

    @Override
    public void setOutputKeyStrategy(KeyStrategy outputKeyStrategy) {
        this.outputKeyStrategy = outputKeyStrategy;
    }

    private static class AgentSubGraphNode
    extends Node
    implements SubGraphNode {
        private final CompiledGraph subGraph;

        public AgentSubGraphNode(String id, boolean includeContents, boolean returnReasoningContents, String outputKeyToParent, CompiledGraph subGraph, String instruction) {
            super(Objects.requireNonNull(id, "id cannot be null"), config -> AsyncNodeActionWithConfig.node_async((NodeActionWithConfig)new SubGraphNodeAdapter(includeContents, returnReasoningContents, outputKeyToParent, subGraph, instruction, config)));
            this.subGraph = subGraph;
        }

        public StateGraph subGraph() {
            return this.subGraph.stateGraph;
        }
    }

    public static class SubGraphNodeAdapter
    implements NodeActionWithConfig {
        private boolean includeContents;
        private boolean returnReasoningContents;
        private String instruction;
        private String outputKeyToParent;
        private CompiledGraph childGraph;
        private CompileConfig parentCompileConfig;

        public SubGraphNodeAdapter(boolean includeContents, boolean returnReasoningContents, String outputKeyToParent, CompiledGraph childGraph, String instruction, CompileConfig parentCompileConfig) {
            this.includeContents = includeContents;
            this.returnReasoningContents = returnReasoningContents;
            this.instruction = instruction;
            this.outputKeyToParent = outputKeyToParent;
            this.childGraph = childGraph;
            this.parentCompileConfig = parentCompileConfig;
        }

        public String subGraphId() {
            return String.format("subgraph_%s", this.childGraph.stateGraph.getName());
        }

        public Map<String, Object> apply(OverAllState parentState, RunnableConfig config) throws Exception {
            Flux subGraphResult;
            RunnableConfig subGraphRunnableConfig = this.getSubGraphRunnableConfig(config);
            Object parentMessages = null;
            if (this.includeContents) {
                if (StringUtils.hasLength((String)this.instruction)) {
                    parentState.updateState(Map.of("messages", new AgentInstructionMessage(this.instruction)));
                }
                subGraphResult = this.childGraph.graphResponseStream(parentState, subGraphRunnableConfig);
            } else {
                HashMap<String, AgentInstructionMessage> stateForChild = new HashMap<String, AgentInstructionMessage>(parentState.data());
                parentMessages = stateForChild.remove("messages");
                if (StringUtils.hasLength((String)this.instruction)) {
                    stateForChild.put("messages", new AgentInstructionMessage(this.instruction));
                }
                subGraphResult = this.childGraph.graphResponseStream(stateForChild, subGraphRunnableConfig);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(StringUtils.hasLength((String)this.outputKeyToParent) ? this.outputKeyToParent : "messages", this.getGraphResponseFlux(parentState, (Flux<GraphResponse<NodeOutput>>)subGraphResult));
            if (parentMessages != null) {
                result.put("messages", parentMessages);
            }
            return result;
        }

        @NotNull
        private Flux<GraphResponse<NodeOutput>> getGraphResponseFlux(OverAllState parentState, Flux<GraphResponse<NodeOutput>> subGraphResult) {
            return Flux.create(sink -> {
                AtomicReference lastRef = new AtomicReference();
                subGraphResult.subscribe(item -> {
                    GraphResponse previous = lastRef.getAndSet(item);
                    if (previous != null) {
                        sink.next((Object)previous);
                    }
                }, arg_0 -> ((FluxSink)sink).error(arg_0), () -> {
                    ArrayList messages;
                    Map resultMap;
                    Object resultValue;
                    GraphResponse lastResponse = (GraphResponse)lastRef.get();
                    if (lastResponse != null && lastResponse.resultValue().isPresent() && (resultValue = lastResponse.resultValue().get()) instanceof Map && (resultMap = (Map)resultValue).get("messages") instanceof List && !(messages = new ArrayList((List)resultMap.get("messages"))).isEmpty()) {
                        parentState.value("messages").ifPresent(parentMsgs -> {
                            if (parentMsgs instanceof List) {
                                messages.removeAll((List)parentMsgs);
                            }
                        });
                        List finalMessages = this.returnReasoningContents ? messages : (!messages.isEmpty() ? List.of(messages.get(messages.size() - 1)) : List.of());
                        HashMap newResultMap = new HashMap(resultMap);
                        newResultMap.put("messages", finalMessages);
                        lastResponse = GraphResponse.done(newResultMap);
                    }
                    sink.next((Object)lastResponse);
                    sink.complete();
                });
            });
        }

        private RunnableConfig getSubGraphRunnableConfig(RunnableConfig config) {
            RunnableConfig subGraphRunnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder((RunnableConfig)config).checkPointId(null).clearContext().nextNode(null).addMetadata("_AGENT_", (Object)this.subGraphId())).build();
            Optional parentSaver = this.parentCompileConfig.checkpointSaver();
            Optional subGraphSaver = this.childGraph.compileConfig.checkpointSaver();
            if (subGraphSaver.isPresent()) {
                if (parentSaver.isEmpty()) {
                    throw new IllegalStateException("Missing CheckpointSaver in parent graph!");
                }
                if (parentSaver.get() == subGraphSaver.get()) {
                    subGraphRunnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder((RunnableConfig)config).threadId(config.threadId().map(threadId -> String.format("%s_%s", threadId, this.subGraphId())).orElseGet(this::subGraphId)).nextNode(null).checkPointId(null).clearContext().addMetadata("_AGENT_", (Object)this.subGraphId())).build();
                }
            }
            return subGraphRunnableConfig;
        }
    }
}

