/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.interceptor;

import com.alibaba.cloud.ai.graph.agent.extension.file.FilesystemBackend;
import com.alibaba.cloud.ai.graph.agent.extension.file.LocalFilesystemBackend;
import com.alibaba.cloud.ai.graph.agent.extension.file.WriteResult;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallResponse;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LargeResultEvictionInterceptor
extends ToolInterceptor {
    private static final int MAX_LINE_LENGTH = 2000;
    private static final int LINE_NUMBER_WIDTH = 6;
    private static final int DEFAULT_TOOL_TOKEN_LIMIT = 20000;
    private static final int SAMPLE_LINES_COUNT = 10;
    private static final int SAMPLE_LINE_MAX_LENGTH = 1000;
    private static final String LARGE_RESULTS_DIR = System.getProperty("user.dir") + "/large_tool_results/";
    private static final String TOO_LARGE_TOOL_MSG = "Tool result too large, the result of this tool call %s was saved in the filesystem at this path: %s\nYou can read the result from the filesystem by using the read_file tool, but make sure to only read part of the result at a time.\nYou can do this by specifying an offset and limit in the read_file tool call.\nFor example, to read the first 100 lines, you can use the read_file tool with offset=0 and limit=100.\n\nHere are the first 10 lines of the result:\n%s\n";
    private final Integer toolTokenLimitBeforeEvict;
    private final Set<String> excludedTools;
    private final FilesystemBackend backend;

    private LargeResultEvictionInterceptor(Builder builder) {
        this.toolTokenLimitBeforeEvict = builder.toolTokenLimitBeforeEvict;
        this.excludedTools = builder.excludedTools != null ? new HashSet<String>(builder.excludedTools) : new HashSet();
        this.backend = builder.backend;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return "LargeResultEviction";
    }

    @Override
    public ToolCallResponse interceptToolCall(ToolCallRequest request, ToolCallHandler handler) {
        ToolCallResponse response = handler.call(request);
        if (!this.shouldEvictResult(request.getToolName(), response.getResult())) {
            return response;
        }
        return this.processLargeResult(response, request.getToolCallId());
    }

    private boolean shouldEvictResult(String toolName, String result) {
        if (this.toolTokenLimitBeforeEvict == null) {
            return false;
        }
        if (this.excludedTools.contains(toolName)) {
            return false;
        }
        if (result == null || result.isEmpty()) {
            return false;
        }
        return result.length() > 4 * this.toolTokenLimitBeforeEvict;
    }

    private ToolCallResponse processLargeResult(ToolCallResponse response, String toolCallId) {
        String content = response.getResult();
        String sanitizedId = LargeResultEvictionInterceptor.sanitizeToolCallId(toolCallId);
        String filePath = LARGE_RESULTS_DIR + sanitizedId;
        if (this.backend != null) {
            WriteResult writeResult = this.backend.write(filePath, content);
            if (writeResult.getError() != null) {
                System.err.println("Warning: Failed to write large result to filesystem: " + writeResult.getError());
            }
        } else {
            System.err.println("Warning: Backend not configured, large result not persisted to filesystem");
        }
        String contentSample = LargeResultEvictionInterceptor.extractContentSample(content);
        String evictedMessage = String.format(TOO_LARGE_TOOL_MSG, toolCallId, filePath, contentSample);
        return ToolCallResponse.builder().content(evictedMessage).toolName(response.getToolName()).toolCallId(response.getToolCallId()).status("evicted_to_filesystem").build();
    }

    private static String sanitizeToolCallId(String toolCallId) {
        if (toolCallId == null) {
            return "unknown";
        }
        return toolCallId.replaceAll("[^a-zA-Z0-9_-]", "_");
    }

    private static String extractContentSample(String content) {
        String[] lines = content.split("\n");
        ArrayList<String> sampleLines = new ArrayList<String>();
        for (int i = 0; i < Math.min(10, lines.length); ++i) {
            Object line = lines[i];
            if (((String)line).length() > 1000) {
                line = ((String)line).substring(0, 1000) + "... (truncated)";
            }
            sampleLines.add((String)line);
        }
        return LargeResultEvictionInterceptor.formatContentWithLineNumbers(sampleLines, 1);
    }

    private static String formatContentWithLineNumbers(List<String> lines, int startLine) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            Object line = lines.get(i);
            if (((String)line).length() > 2000) {
                line = ((String)line).substring(0, 2000) + "... (line truncated)";
            }
            result.append(String.format("%6d\t%s\n", startLine + i, line));
        }
        return result.toString();
    }

    public static class Builder {
        private Integer toolTokenLimitBeforeEvict = 20000;
        private Set<String> excludedTools;
        private FilesystemBackend backend;

        public Builder toolTokenLimitBeforeEvict(Integer toolTokenLimitBeforeEvict) {
            this.toolTokenLimitBeforeEvict = toolTokenLimitBeforeEvict;
            return this;
        }

        public Builder excludeTools(Set<String> excludedTools) {
            this.excludedTools = excludedTools;
            return this;
        }

        public Builder excludeTool(String toolName) {
            if (this.excludedTools == null) {
                this.excludedTools = new HashSet<String>();
            }
            this.excludedTools.add(toolName);
            return this;
        }

        public Builder backend(FilesystemBackend backend) {
            this.backend = backend;
            return this;
        }

        public Builder excludeFilesystemTools() {
            return this.excludeTools(Set.of("ls", "read_file", "write_file", "edit_file", "glob", "grep"));
        }

        public LargeResultEvictionInterceptor build() {
            if (this.backend == null && this.toolTokenLimitBeforeEvict != null) {
                this.backend = new LocalFilesystemBackend(null, false, 10);
            }
            return new LargeResultEvictionInterceptor(this);
        }
    }
}

