/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.interceptor;

import com.alibaba.cloud.ai.graph.agent.ReactAgent;
import com.alibaba.cloud.ai.graph.agent.extension.interceptor.SubAgentSpec;
import com.alibaba.cloud.ai.graph.agent.extension.tools.model.TaskTool;
import com.alibaba.cloud.ai.graph.agent.hook.Hook;
import com.alibaba.cloud.ai.graph.agent.interceptor.Interceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import com.alibaba.cloud.ai.graph.checkpoint.BaseCheckpointSaver;
import com.alibaba.cloud.ai.graph.checkpoint.savers.MemorySaver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.tool.ToolCallback;

public class SubAgentInterceptor
extends ModelInterceptor {
    private static final String DEFAULT_SUBAGENT_PROMPT = "In order to complete the objective that the user asks of you, you have access to a number of standard tools.";
    private static final String DEFAULT_SYSTEM_PROMPT = "## `task` (subagent spawner)\n\nYou have access to a `task` tool to launch short-lived subagents that handle isolated tasks. These agents are ephemeral \u2014 they live only for the duration of the task and return a single result.\n\nWhen to use the task tool:\n- When a task is complex and multi-step, and can be fully delegated in isolation\n- When a task is independent of other tasks and can run in parallel\n- When a task requires focused reasoning or heavy token/context usage that would bloat the orchestrator thread\n- When sandboxing improves reliability (e.g. code execution, structured searches, data formatting)\n- When you only care about the output of the subagent, and not the intermediate steps (ex. performing a lot of research and then returned a synthesized report, performing a series of computations or lookups to achieve a concise, relevant answer.)\n\nSubagent lifecycle:\n1. **Spawn** \u2192 Provide clear role, instructions, and expected output\n2. **Run** \u2192 The subagent completes the task autonomously\n3. **Return** \u2192 The subagent provides a single structured result\n4. **Reconcile** \u2192 Incorporate or synthesize the result into the main thread\n\nWhen NOT to use the task tool:\n- If you need to see the intermediate reasoning or steps after the subagent has completed (the task tool hides them)\n- If the task is trivial (a few tool calls or simple lookup)\n- If delegating does not reduce token usage, complexity, or context switching\n- If splitting would add latency without benefit\n\n## Important Task Tool Usage Notes to Remember\n- Whenever possible, parallelize the work that you do. This is true for both tool_calls, and for tasks. Whenever you have independent steps to complete - make tool_calls, or kick off tasks (subagents) in parallel to accomplish them faster. This saves time for the user, which is incredibly important.\n- Remember to use the `task` tool to silo independent tasks within a multi-part objective.\n- You should use the `task` tool whenever you have a complex task that will take multiple steps, and is independent from other tasks that the agent needs to complete. These agents are highly competent and efficient.\n";
    private static final String DEFAULT_GENERAL_PURPOSE_DESCRIPTION = "General-purpose agent for researching complex questions, searching for files and content, and executing multi-step tasks. This agent has access to all tools as the main agent.";
    private static final String TASK_TOOL_DESCRIPTION = "Launch an ephemeral subagent to handle complex, multi-step independent tasks with isolated context.\n\nAvailable agent types and the tools they have access to:\n{available_agents}\n\nWhen using the Task tool, you must specify a subagent_type parameter to select which agent type to use.\n\n## Usage notes:\n1. Launch multiple agents concurrently whenever possible to maximize performance\n2. When the agent is done, it will return a single message back to you\n3. Each agent invocation is stateless - provide a highly detailed task description\n4. The agent's outputs should generally be trusted\n5. Clearly tell the agent whether you expect it to create content, perform analysis, or just do research\n6. If the agent description mentions that it should be used proactively, then you should try your best to use it without the user having to ask for it first. Use your judgement.\n7. When only the general-purpose agent is provided, you should use it for all tasks. It is great for isolating context and token usage, and completing specific, complex tasks, as it has all the same capabilities as the main agent.\n\n### Example usage of the general-purpose agent:\n\n<example_agent_descriptions>\n\"general-purpose\": use this agent for general purpose tasks, it has access to all tools as the main agent.\n</example_agent_descriptions>\n\n<example>\nUser: \"I want to conduct research on the accomplishments of Lebron James, Michael Jordan, and Kobe Bryant, and then compare them.\"\nAssistant: *Uses the task tool in parallel to conduct isolated research on each of the three players*\nAssistant: *Synthesizes the results of the three isolated research tasks and responds to the User*\n<commentary>\nResearch is a complex, multi-step task in it of itself.\nThe research of each individual player is not dependent on the research of the other players.\nThe assistant uses the task tool to break down the complex objective into three isolated tasks.\nEach research task only needs to worry about context and tokens about one player, then returns synthesized information about each player as the Tool Result.\nThis means each research task can dive deep and spend tokens and context deeply researching each player, but the final result is synthesized information, and saves us tokens in the long run when comparing the players to each other.\n</commentary>\n</example>\n\n<example>\nUser: \"Analyze a single large code repository for security vulnerabilities and generate a report.\"\nAssistant: *Launches a single `task` subagent for the repository analysis*\nAssistant: *Receives report and integrates results into final summary*\n<commentary>\nSubagent is used to isolate a large, context-heavy task, even though there is only one. This prevents the main thread from being overloaded with details.\nIf the user then asks followup questions, we have a concise report to reference instead of the entire history of analysis and tool calls, which is good and saves us time and money.\n</commentary>\n</example>\n\n<example>\nUser: \"Schedule two meetings for me and prepare agendas for each.\"\nAssistant: *Calls the task tool in parallel to launch two `task` subagents (one per meeting) to prepare agendas*\nAssistant: *Returns final schedules and agendas*\n<commentary>\nTasks are simple individually, but subagents help silo agenda preparation.\nEach subagent only needs to worry about the agenda for one meeting.\n</commentary>\n</example>\n\n<example>\nUser: \"I want to order a pizza from Dominos, order a burger from McDonald's, and order a salad from Subway.\"\nAssistant: *Calls tools directly in parallel to order a pizza from Dominos, a burger from McDonald's, and a salad from Subway*\n<commentary>\nThe assistant did not use the task tool because the objective is super simple and clear and only requires a few trivial tool calls.\nIt is better to just complete the task directly and NOT use the `task`tool.\n</commentary>\n</example>\n\n### Example usage with custom agents:\n\n<example_agent_descriptions>\n\"content-reviewer\": use this agent after you are done creating significant content or documents\n\"greeting-responder\": use this agent when to respond to user greetings with a friendly joke\n\"research-analyst\": use this agent to conduct thorough research on complex topics\n</example_agent_description>\n\n<example>\nuser: \"Please write a function that checks if a number is prime\"\nassistant: Sure let me write a function that checks if a number is prime\nassistant: First let me use the Write tool to write a function that checks if a number is prime\nassistant: I'm going to use the Write tool to write the following code:\n<code>\nfunction isPrime(n) {{\n  if (n <= 1) return false\n  for (let i = 2; i * i <= n; i++) {{\n    if (n % i === 0) return false\n  }}\n  return true\n}}\n</code>\n<commentary>\nSince significant content was created and the task was completed, now use the content-reviewer agent to review the work\n</commentary>\nassistant: Now let me use the content-reviewer agent to review the code\nassistant: Uses the Task tool to launch with the content-reviewer agent\n</example>\n\n<example>\nuser: \"Can you help me research the environmental impact of different renewable energy sources and create a comprehensive report?\"\n<commentary>\nThis is a complex research task that would benefit from using the research-analyst agent to conduct thorough analysis\n</commentary>\nassistant: I'll help you research the environmental impact of renewable energy sources. Let me use the research-analyst agent to conduct comprehensive research on this topic.\nassistant: Uses the Task tool to launch with the research-analyst agent, providing detailed instructions about what research to conduct and what format the report should take\n</example>\n\n<example>\nuser: \"Hello\"\n<commentary>\nSince the user is greeting, use the greeting-responder agent to respond with a friendly joke\n</commentary>\nassistant: \"I'm going to use the Task tool to launch with the greeting-responder agent\"\n</example>\n";
    private final List<ToolCallback> tools;
    private final String systemPrompt;
    private final Map<String, ReactAgent> subAgents;
    private final boolean includeGeneralPurpose;

    private SubAgentInterceptor(Builder builder) {
        this.systemPrompt = builder.systemPrompt != null ? builder.systemPrompt : DEFAULT_SYSTEM_PROMPT;
        this.subAgents = new HashMap<String, ReactAgent>(builder.subAgents);
        this.includeGeneralPurpose = builder.includeGeneralPurpose;
        if (this.includeGeneralPurpose && builder.defaultModel != null) {
            ReactAgent generalPurposeAgent = this.createGeneralPurposeAgent(builder.defaultModel, builder.defaultTools, builder.defaultInterceptors);
            this.subAgents.put("general-purpose", generalPurposeAgent);
        }
        ToolCallback taskTool = TaskTool.createTaskToolCallback(this.subAgents, this.buildTaskToolDescription());
        this.tools = Collections.singletonList(taskTool);
    }

    private ReactAgent createGeneralPurposeAgent(ChatModel model, List<ToolCallback> tools, List<? extends Interceptor> interceptors) {
        com.alibaba.cloud.ai.graph.agent.Builder builder = ReactAgent.builder().name("general-purpose").model(model).systemPrompt(DEFAULT_SUBAGENT_PROMPT).saver((BaseCheckpointSaver)new MemorySaver());
        if (tools != null && !tools.isEmpty()) {
            builder.tools(tools);
        }
        if (interceptors != null && !interceptors.isEmpty()) {
            builder.interceptors(interceptors);
        }
        return builder.build();
    }

    private String buildTaskToolDescription() {
        StringBuilder agentDescriptions = new StringBuilder();
        if (this.includeGeneralPurpose) {
            agentDescriptions.append("- general-purpose: ").append(DEFAULT_GENERAL_PURPOSE_DESCRIPTION).append("\n");
        }
        for (Map.Entry<String, ReactAgent> entry : this.subAgents.entrySet()) {
            if ("general-purpose".equals(entry.getKey())) continue;
            agentDescriptions.append("- ").append(entry.getKey()).append(": ").append(entry.getValue().description() != null ? entry.getValue().description() : "Custom subagent").append("\n");
        }
        return TASK_TOOL_DESCRIPTION.replace("{available_agents}", agentDescriptions.toString());
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<ToolCallback> getTools() {
        return this.tools;
    }

    @Override
    public String getName() {
        return "SubAgent";
    }

    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        SystemMessage enhancedSystemMessage = request.getSystemMessage() == null ? new SystemMessage(this.systemPrompt) : new SystemMessage(request.getSystemMessage().getText() + "\n\n" + this.systemPrompt);
        ModelRequest enhancedRequest = ModelRequest.builder(request).systemMessage(enhancedSystemMessage).build();
        return handler.call(enhancedRequest);
    }

    public static class Builder {
        private String systemPrompt;
        private ChatModel defaultModel;
        private List<ToolCallback> defaultTools;
        private List<Interceptor> defaultInterceptors;
        private List<Hook> defaultHooks;
        private Map<String, ReactAgent> subAgents = new HashMap<String, ReactAgent>();
        private boolean includeGeneralPurpose = true;

        public Builder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        public Builder defaultModel(ChatModel model) {
            this.defaultModel = model;
            return this;
        }

        public Builder defaultTools(List<ToolCallback> tools) {
            this.defaultTools = tools;
            return this;
        }

        public Builder defaultInterceptors(Interceptor ... interceptors) {
            this.defaultInterceptors = Arrays.asList(interceptors);
            return this;
        }

        public Builder defaultHooks(Hook ... hooks) {
            this.defaultHooks = Arrays.asList(hooks);
            return this;
        }

        public Builder addSubAgent(String name, ReactAgent agent) {
            this.subAgents.put(name, agent);
            return this;
        }

        public Builder addSubAgent(SubAgentSpec spec) {
            ReactAgent agent = this.createSubAgentFromSpec(spec);
            this.subAgents.put(spec.getName(), agent);
            return this;
        }

        public Builder includeGeneralPurpose(boolean include) {
            this.includeGeneralPurpose = include;
            return this;
        }

        private ReactAgent createSubAgentFromSpec(SubAgentSpec spec) {
            List<ToolCallback> tools;
            ChatModel model;
            com.alibaba.cloud.ai.graph.agent.Builder builder = ReactAgent.builder().name(spec.getName()).description(spec.getDescription()).instruction(spec.getSystemPrompt()).saver((BaseCheckpointSaver)new MemorySaver());
            ChatModel chatModel = model = spec.getModel() != null ? spec.getModel() : this.defaultModel;
            if (model != null) {
                builder.model(model);
            }
            List<ToolCallback> list = tools = spec.getTools() != null ? spec.getTools() : this.defaultTools;
            if (tools != null && !tools.isEmpty()) {
                builder.tools(tools);
            }
            ArrayList<Interceptor> allInterceptors = new ArrayList<Interceptor>();
            if (this.defaultInterceptors != null) {
                allInterceptors.addAll(this.defaultInterceptors);
            }
            if (spec.getInterceptors() != null) {
                allInterceptors.addAll(spec.getInterceptors());
            }
            if (!allInterceptors.isEmpty()) {
                builder.interceptors(allInterceptors);
            }
            if (this.defaultHooks != null) {
                builder.hooks(this.defaultHooks);
            }
            builder.enableLogging(spec.isEnableLoopingLog());
            return builder.build();
        }

        public SubAgentInterceptor build() {
            return new SubAgentInterceptor(this);
        }
    }
}

