/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.extension.interceptor;

import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import java.util.List;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.tool.ToolCallback;

public class SubAgentSpec {
    private final String name;
    private final String description;
    private final String systemPrompt;
    private final ChatModel model;
    private final List<ToolCallback> tools;
    private final List<ModelInterceptor> interceptors;
    private final boolean enableLoopingLog;

    private SubAgentSpec(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.systemPrompt = builder.systemPrompt;
        this.model = builder.model;
        this.tools = builder.tools;
        this.interceptors = builder.interceptors;
        this.enableLoopingLog = builder.enableLoopingLog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    public ChatModel getModel() {
        return this.model;
    }

    public List<ToolCallback> getTools() {
        return this.tools;
    }

    public List<ModelInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public boolean isEnableLoopingLog() {
        return this.enableLoopingLog;
    }

    public static class Builder {
        private String name;
        private String description;
        private String systemPrompt;
        private ChatModel model;
        private List<ToolCallback> tools;
        private List<ModelInterceptor> interceptors;
        private boolean enableLoopingLog;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        public Builder model(ChatModel model) {
            this.model = model;
            return this;
        }

        public Builder tools(List<ToolCallback> tools) {
            this.tools = tools;
            return this;
        }

        public Builder interceptors(List<ModelInterceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public Builder enableLoopingLog(boolean enableLoopingLog) {
            this.enableLoopingLog = enableLoopingLog;
            return this;
        }

        public SubAgentSpec build() {
            if (this.name == null || this.name.trim().isEmpty()) {
                throw new IllegalArgumentException("SubAgent name is required");
            }
            if (this.description == null || this.description.trim().isEmpty()) {
                throw new IllegalArgumentException("SubAgent description is required");
            }
            if (this.systemPrompt == null || this.systemPrompt.trim().isEmpty()) {
                throw new IllegalArgumentException("SubAgent system prompt is required");
            }
            return new SubAgentSpec(this);
        }
    }
}

