/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.flow.agent;

import com.alibaba.cloud.ai.graph.CompileConfig;
import com.alibaba.cloud.ai.graph.CompiledGraph;
import com.alibaba.cloud.ai.graph.StateGraph;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.flow.builder.FlowGraphBuilder;
import com.alibaba.cloud.ai.graph.exception.GraphStateException;
import com.alibaba.cloud.ai.graph.scheduling.ScheduleConfig;
import com.alibaba.cloud.ai.graph.scheduling.ScheduledAgentTask;
import com.alibaba.cloud.ai.graph.utils.Messageutils;
import java.util.List;
import java.util.Map;

public abstract class FlowAgent
extends Agent {
    protected List<String> interruptBefore;
    protected List<Agent> subAgents;

    protected FlowAgent(String name, String description, CompileConfig compileConfig, List<Agent> subAgents) throws GraphStateException {
        super(name, description);
        this.compileConfig = compileConfig;
        this.subAgents = subAgents;
    }

    @Override
    protected StateGraph initGraph() throws GraphStateException {
        FlowGraphBuilder.FlowGraphConfig config = FlowGraphBuilder.FlowGraphConfig.builder().name(this.name()).rootAgent(this).subAgents(this.subAgents());
        return this.buildSpecificGraph(config);
    }

    @Override
    public ScheduledAgentTask schedule(ScheduleConfig scheduleConfig) throws GraphStateException {
        CompiledGraph compiledGraph = this.getAndCompileGraph();
        return compiledGraph.schedule(scheduleConfig);
    }

    public StateGraph asStateGraph() {
        return this.getGraph();
    }

    protected abstract StateGraph buildSpecificGraph(FlowGraphBuilder.FlowGraphConfig var1) throws GraphStateException;

    public CompileConfig compileConfig() {
        return this.compileConfig;
    }

    public List<Agent> subAgents() {
        return this.subAgents;
    }

    private Map<String, Object> createInputMap(String message) {
        return Map.of("messages", Messageutils.convertToMessages((Object)message), "input", message);
    }
}

