/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.hook.shelltool;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.agent.hook.AgentHook;
import com.alibaba.cloud.ai.graph.agent.hook.HookPosition;
import com.alibaba.cloud.ai.graph.agent.hook.HookPositions;
import com.alibaba.cloud.ai.graph.agent.hook.HookType;
import com.alibaba.cloud.ai.graph.agent.hook.JumpTo;
import com.alibaba.cloud.ai.graph.agent.hook.ToolInjection;
import com.alibaba.cloud.ai.graph.agent.tools.ShellTool;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.tool.ToolCallback;

@HookPositions(value={HookPosition.BEFORE_AGENT, HookPosition.AFTER_AGENT})
public class ShellToolAgentHook
extends AgentHook
implements ToolInjection {
    private static final Logger log = LoggerFactory.getLogger(ShellToolAgentHook.class);
    private ShellTool shellTool;

    private ShellToolAgentHook() {
    }

    private ShellToolAgentHook(ShellTool shellTool) {
        this.shellTool = shellTool;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CompletableFuture<Map<String, Object>> beforeAgent(OverAllState state, RunnableConfig config) {
        if (this.shellTool == null) {
            log.warn("ShellToolAgentHook: No ShellTool injected, skipping initialization");
            return CompletableFuture.completedFuture(new HashMap());
        }
        log.info("ShellToolAgentHook: Initializing shell session before agent execution");
        try {
            this.shellTool.getSessionManager().initialize(config);
            log.info("Shell session initialized successfully");
        }
        catch (Exception e) {
            log.error("Failed to initialize shell session", (Throwable)e);
            throw new RuntimeException("Failed to initialize shell session", e);
        }
        return CompletableFuture.completedFuture(new HashMap());
    }

    @Override
    public CompletableFuture<Map<String, Object>> afterAgent(OverAllState state, RunnableConfig config) {
        if (this.shellTool == null) {
            log.warn("ShellToolAgentHook: No ShellTool injected, skipping cleanup");
            return CompletableFuture.completedFuture(new HashMap());
        }
        log.info("ShellToolAgentHook: Cleaning up shell session after agent execution");
        try {
            this.shellTool.getSessionManager().cleanup(config);
            log.info("Shell session cleaned up successfully");
        }
        catch (Exception e) {
            log.error("Failed to cleanup shell session", (Throwable)e);
        }
        return CompletableFuture.completedFuture(new HashMap());
    }

    @Override
    public String getName() {
        return "ShellToolAgentHook";
    }

    @Override
    public HookType getHookType() {
        return HookType.AGENT;
    }

    @Override
    public List<JumpTo> canJumpTo() {
        return List.of();
    }

    @Override
    public void injectTool(ToolCallback toolCallback) {
        log.info("ShellToolAgentHook: Processing tool callback for shell tool extraction");
        try {
            ShellTool extracted = this.extractShellTool(toolCallback);
            if (extracted != null) {
                this.shellTool = extracted;
                log.info("Successfully extracted and injected ShellTool from tool: {}", (Object)toolCallback.getToolDefinition().name());
            } else {
                log.warn("Failed to extract ShellTool from tool: {}", (Object)toolCallback.getToolDefinition().name());
            }
        }
        catch (Exception e) {
            log.error("Error extracting ShellTool from tool callback", (Throwable)e);
        }
    }

    private ShellTool extractShellTool(ToolCallback toolCallback) {
        try {
            for (Class<?> clazz = toolCallback.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Field functionField = clazz.getDeclaredField("toolFunction");
                    functionField.setAccessible(true);
                    Object function = functionField.get(toolCallback);
                    if (function instanceof ShellTool) {
                        return (ShellTool)function;
                    }
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            log.debug("Could not extract ShellTool from ToolCallback via reflection", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getRequiredToolName() {
        return "shell";
    }

    @Override
    public Class<? extends ToolCallback> getRequiredToolType() {
        return null;
    }

    protected ShellTool getShellTool() {
        return this.shellTool;
    }

    public static class Builder {
        private ShellTool shellTool;

        public Builder shellTool(ShellTool shellTool) {
            this.shellTool = shellTool;
            return this;
        }

        public ShellToolAgentHook build() {
            return new ShellToolAgentHook(this.shellTool);
        }
    }
}

