/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor;

import java.util.Map;
import org.springframework.ai.chat.messages.AssistantMessage;

public class ToolCallRequest {
    private final String toolName;
    private final String arguments;
    private final String toolCallId;
    private final Map<String, Object> context;

    public ToolCallRequest(String toolName, String arguments, String toolCallId, Map<String, Object> context) {
        this.toolName = toolName;
        this.arguments = arguments;
        this.toolCallId = toolCallId;
        this.context = context;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ToolCallRequest request) {
        return new Builder().toolName(request.toolName).arguments(request.arguments).toolCallId(request.toolCallId).context(request.context);
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getArguments() {
        return this.arguments;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public static class Builder {
        private String toolName;
        private String arguments;
        private String toolCallId;
        private Map<String, Object> context;

        public Builder toolCall(AssistantMessage.ToolCall toolCall) {
            this.toolName = toolCall.name();
            this.arguments = toolCall.arguments();
            this.toolCallId = toolCall.id();
            return this;
        }

        public Builder toolName(String toolName) {
            this.toolName = toolName;
            return this;
        }

        public Builder arguments(String arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder toolCallId(String toolCallId) {
            this.toolCallId = toolCallId;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public ToolCallRequest build() {
            return new ToolCallRequest(this.toolName, this.arguments, this.toolCallId, this.context);
        }
    }
}

