/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor.modelfallback;

import com.alibaba.cloud.ai.graph.agent.interceptor.ModelCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelInterceptor;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ModelResponse;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;

public class ModelFallbackInterceptor
extends ModelInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ModelFallbackInterceptor.class);
    private final List<ChatModel> fallbackModels;

    private ModelFallbackInterceptor(Builder builder) {
        this.fallbackModels = new ArrayList<ChatModel>(builder.fallbackModels);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ModelResponse interceptModel(ModelRequest request, ModelCallHandler handler) {
        Exception lastException = null;
        try {
            ModelResponse modelResponse = handler.call(request);
            Message message = (Message)modelResponse.getMessage();
            if (message.getText() != null && message.getText().contains("Exception:")) {
                throw new RuntimeException(message.getText());
            }
            return modelResponse;
        }
        catch (Exception e) {
            log.warn("Primary model failed: {}", (Object)e.getMessage());
            lastException = e;
            for (int i = 0; i < this.fallbackModels.size(); ++i) {
                ChatModel fallbackModel = this.fallbackModels.get(i);
                try {
                    log.info("Trying fallback model {} of {}", (Object)(i + 1), (Object)this.fallbackModels.size());
                    Prompt prompt = new Prompt(request.getMessages(), request.getOptions());
                    ChatResponse response = fallbackModel.call(prompt);
                    return ModelResponse.of(response.getResult().getOutput());
                }
                catch (Exception e2) {
                    log.warn("Fallback model {} failed: {}", (Object)(i + 1), (Object)e2.getMessage());
                    lastException = e2;
                    continue;
                }
            }
            throw new RuntimeException("All models failed after " + (this.fallbackModels.size() + 1) + " attempts", lastException);
        }
    }

    @Override
    public String getName() {
        return "ModelFallback";
    }

    public static class Builder {
        private final List<ChatModel> fallbackModels = new ArrayList<ChatModel>();

        public Builder addFallbackModel(ChatModel model) {
            this.fallbackModels.add(model);
            return this;
        }

        public Builder fallbackModels(List<ChatModel> models) {
            this.fallbackModels.addAll(models);
            return this;
        }

        public ModelFallbackInterceptor build() {
            if (this.fallbackModels.isEmpty()) {
                throw new IllegalArgumentException("At least one fallback model must be specified");
            }
            return new ModelFallbackInterceptor(this);
        }
    }
}

