/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.graph.agent.interceptor.toolemulator;

import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallHandler;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallRequest;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolCallResponse;
import com.alibaba.cloud.ai.graph.agent.interceptor.ToolInterceptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.Prompt;

public class ToolEmulatorInterceptor
extends ToolInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ToolEmulatorInterceptor.class);
    private final ChatModel emulatorModel;
    private final boolean emulateAll;
    private final Set<String> toolsToEmulate;
    private final String promptTemplate;

    private ToolEmulatorInterceptor(Builder builder) {
        this.emulatorModel = builder.emulatorModel;
        this.emulateAll = builder.emulateAll;
        this.toolsToEmulate = new HashSet<String>(builder.toolsToEmulate);
        this.promptTemplate = builder.promptTemplate;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return "ToolEmulator";
    }

    @Override
    public ToolCallResponse interceptToolCall(ToolCallRequest request, ToolCallHandler handler) {
        boolean shouldEmulate;
        String toolName = request.getToolName();
        boolean bl = shouldEmulate = this.emulateAll || this.toolsToEmulate.contains(toolName);
        if (!shouldEmulate) {
            return handler.call(request);
        }
        log.info("Emulating tool call: {}", (Object)toolName);
        try {
            String prompt = String.format(this.promptTemplate, toolName, "No description available", request.getArguments());
            ChatResponse response = this.emulatorModel.call(new Prompt((Message)new UserMessage(prompt)));
            String emulatedResult = response.getResult().getOutput().getText();
            log.debug("Emulated tool '{}' returned: {}", (Object)toolName, emulatedResult.length() > 100 ? emulatedResult.substring(0, 100) + "..." : emulatedResult);
            return ToolCallResponse.of(request.getToolCallId(), toolName, emulatedResult);
        }
        catch (Exception e) {
            log.error("Failed to emulate tool call for: {}", (Object)toolName, (Object)e);
            return handler.call(request);
        }
    }

    public static class Builder {
        private final Set<String> toolsToEmulate = new HashSet<String>();
        private ChatModel emulatorModel;
        private boolean emulateAll = true;
        private String promptTemplate = "You are emulating a tool call for testing purposes.\n\nTool: %s\nDescription: %s\nArguments: %s\n\nGenerate a realistic response that this tool would return given these arguments.\nReturn ONLY the tool's output, no explanation or preamble.\nIntroduce variation into your responses.\n";

        public Builder model(ChatModel model) {
            this.emulatorModel = model;
            return this;
        }

        public Builder addTool(String toolName) {
            this.toolsToEmulate.add(toolName);
            return this;
        }

        public Builder addTools(Collection<String> toolNames) {
            this.toolsToEmulate.addAll(toolNames);
            return this;
        }

        public Builder emulateAllTools(boolean emulateAll) {
            this.emulateAll = emulateAll;
            return this;
        }

        public Builder promptTemplate(String template) {
            this.promptTemplate = template;
            return this;
        }

        public ToolEmulatorInterceptor build() {
            if (this.emulatorModel == null) {
                throw new IllegalStateException("Emulator model is required");
            }
            return new ToolEmulatorInterceptor(this);
        }
    }
}

