/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.client.prompt;

import com.alibaba.cloud.ai.observation.model.ObservationMetadataAwareOptions;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import java.util.Collections;
import java.util.Map;
import org.springframework.ai.chat.client.observation.ChatClientObservationContext;
import org.springframework.ai.chat.client.observation.DefaultChatClientObservationConvention;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.lang.NonNull;

public class PromptMetadataAwareChatClientObservationConvention
extends DefaultChatClientObservationConvention {
    @NonNull
    public KeyValues getLowCardinalityKeyValues(@NonNull ChatClientObservationContext context) {
        return super.getLowCardinalityKeyValues(context);
    }

    @NonNull
    public KeyValues getHighCardinalityKeyValues(@NonNull ChatClientObservationContext context) {
        KeyValues keyValues = super.getHighCardinalityKeyValues(context);
        keyValues = this.promptKey(keyValues, context);
        keyValues = this.promptVersion(keyValues, context);
        keyValues = this.promptTemplate(keyValues, context);
        keyValues = this.promptVariables(keyValues, context);
        keyValues = this.agentName(keyValues, context);
        keyValues = this.agentIp(keyValues, context);
        keyValues = this.studioSource(keyValues, context);
        return keyValues;
    }

    protected KeyValues promptKey(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptKey")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.key", (String)metadata.get("promptKey"))});
        }
        return keyValues;
    }

    protected KeyValues promptVersion(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptVersion")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.version", (String)metadata.get("promptVersion"))});
        }
        return keyValues;
    }

    protected KeyValues promptTemplate(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptTemplate")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.template", (String)metadata.get("promptTemplate"))});
        }
        return keyValues;
    }

    protected KeyValues promptVariables(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("promptVariables")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.prompt.variable", (String)metadata.get("promptVariables"))});
        }
        return keyValues;
    }

    protected KeyValues agentName(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("agentName")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.agent.name", (String)metadata.get("agentName"))});
        }
        return keyValues;
    }

    protected KeyValues agentIp(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("agentIp")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.agent.ip", (String)metadata.get("agentIp"))});
        }
        return keyValues;
    }

    protected KeyValues studioSource(KeyValues keyValues, ChatClientObservationContext context) {
        Map<String, String> metadata = this.getMetadata(context);
        if (metadata.containsKey("studioSource")) {
            return keyValues.and(new KeyValue[]{KeyValue.of((String)"spring.ai.alibaba.studio.source", (String)metadata.get("studioSource"))});
        }
        return keyValues;
    }

    private Map<String, String> getMetadata(ChatClientObservationContext context) {
        Map<String, String> metadata;
        ChatOptions options = context.getRequest().prompt().getOptions();
        if (options instanceof ObservationMetadataAwareOptions && (metadata = ((ObservationMetadataAwareOptions)options).getObservationMetadata()) != null) {
            return metadata;
        }
        return Collections.emptyMap();
    }
}

