/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.observation.model;

import com.alibaba.cloud.ai.observation.model.OpenTelemetrySpanBridge;
import com.alibaba.cloud.ai.observation.model.semconv.InputOutputModel;
import com.alibaba.cloud.ai.observation.model.semconv.InputOutputUtils;
import com.alibaba.cloud.ai.observation.model.semconv.MessageMode;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.observation.ChatModelObservationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ChatModelOutputObservationHandler
implements ObservationHandler<ChatModelObservationContext> {
    private static final Logger logger = LoggerFactory.getLogger(ChatModelOutputObservationHandler.class);
    private final AttributeKey<String> outputMessagesKey;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ChatModelOutputObservationHandler(MessageMode mode) {
        this.outputMessagesKey = mode == MessageMode.LANGFUSE ? AttributeKey.stringKey((String)"output.values") : AttributeKey.stringKey((String)"gen_ai.output.messages");
    }

    public void onStop(ChatModelObservationContext context) {
        String outputMessages;
        TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)context.get(TracingObservationHandler.TracingContext.class);
        Span otelSpan = OpenTelemetrySpanBridge.retrieveOtelSpan(tracingContext);
        if (otelSpan != null && (outputMessages = this.getOutputMessages(context)) != null) {
            otelSpan.setAttribute(this.outputMessagesKey, (Object)outputMessages);
        }
    }

    @Nullable
    private String getOutputMessages(ChatModelObservationContext context) {
        if (context.getResponse() == null || ((ChatResponse)context.getResponse()).getResults() == null || CollectionUtils.isEmpty((Collection)((ChatResponse)context.getResponse()).getResults())) {
            return null;
        }
        if (!StringUtils.hasText((String)((ChatResponse)context.getResponse()).getResult().getOutput().getText())) {
            return "";
        }
        List<InputOutputModel.OutputMessage> messages = ((ChatResponse)context.getResponse()).getResults().stream().filter(generation -> generation.getOutput() != null && generation.getMetadata() != null).map(InputOutputUtils::convertFromGeneration).toList();
        try {
            return this.objectMapper.writeValueAsString(messages);
        }
        catch (JsonProcessingException e) {
            logger.warn("Failed to convert output message to JSON string", (Throwable)e);
            return null;
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof ChatModelObservationContext;
    }
}

