/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.StringUtils;

public abstract class AbstractNacosDataParser {
    protected static final String DOT = ".";
    protected static final String VALUE = "value";
    private String extension;
    private AbstractNacosDataParser nextParser;

    protected AbstractNacosDataParser(String extension) {
        if (StringUtils.isEmpty((Object)extension)) {
            throw new IllegalArgumentException("extension cannot be empty");
        }
        this.extension = extension.toLowerCase();
    }

    public final boolean checkFileExtension(String extension) {
        if (this.isLegal(extension.toLowerCase())) {
            return true;
        }
        if (this.nextParser == null) {
            return false;
        }
        return this.nextParser.checkFileExtension(extension);
    }

    public final Properties parseNacosData(String data, String extension) throws IOException {
        if (extension == null || extension.length() < 1) {
            throw new IllegalStateException("The file extension cannot be empty");
        }
        if (this.isLegal(extension.toLowerCase())) {
            return this.doParse(data);
        }
        if (this.nextParser == null) {
            throw new IllegalStateException(AbstractNacosDataParser.getTips(extension));
        }
        return this.nextParser.parseNacosData(data, extension);
    }

    protected abstract Properties doParse(String var1) throws IOException;

    protected AbstractNacosDataParser setNextParser(AbstractNacosDataParser nextParser) {
        this.nextParser = nextParser;
        return this;
    }

    public AbstractNacosDataParser addNextParser(AbstractNacosDataParser nextParser) {
        if (this.nextParser == null) {
            this.nextParser = nextParser;
        } else {
            this.nextParser.addNextParser(nextParser);
        }
        return this;
    }

    protected boolean isLegal(String extension) {
        return this.extension.equalsIgnoreCase(extension) || this.extension.contains(extension);
    }

    protected Properties generateProperties(Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isEmpty((Object)key)) continue;
            key = key.startsWith(DOT) ? key.replaceFirst("\\.", "") : key;
            properties.put(key, entry.getValue());
        }
        return properties;
    }

    protected Map<String, String> reloadMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(map);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            int idx;
            String suffix;
            String key = entry.getKey();
            if (!key.contains(DOT) || !VALUE.equalsIgnoreCase(suffix = key.substring((idx = key.lastIndexOf(DOT)) + 1))) continue;
            result.put(key.substring(0, idx), entry.getValue());
        }
        return result;
    }

    public static String getTips(String fileName) {
        return String.format("[%s] must contains file extension with properties|yaml|yml|xml|json", fileName);
    }
}

