/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractNacosDataParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class NacosDataJsonParser
extends AbstractNacosDataParser {
    protected NacosDataJsonParser() {
        super("json");
    }

    @Override
    protected Properties doParse(String data) throws IOException {
        if (StringUtils.isEmpty((Object)data)) {
            return null;
        }
        Map<String, String> map = NacosDataJsonParser.parseJSON2Map(data);
        return this.generateProperties(this.reloadMap(map));
    }

    public static Map<String, String> parseJSON2Map(String json) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>(32);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(json);
        if (null == jsonNode) {
            return map;
        }
        NacosDataJsonParser.parseJsonNode(map, jsonNode, "");
        return map;
    }

    private static void parseJsonNode(Map<String, String> jsonMap, JsonNode jsonNode, String parentKey) {
        Iterator fieldNames = jsonNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fullKey;
            String name = (String)fieldNames.next();
            String string = fullKey = StringUtils.isEmpty((Object)parentKey) ? name : parentKey + "." + name;
            JsonNode resultValue = jsonNode.findValue(name);
            if (null == resultValue) continue;
            if (resultValue.isArray()) {
                Iterator iterator = resultValue.elements();
                while (iterator != null && iterator.hasNext()) {
                    JsonNode next = (JsonNode)iterator.next();
                    if (null == next) continue;
                    NacosDataJsonParser.parseJsonNode(jsonMap, next, fullKey);
                }
                continue;
            }
            if (resultValue.isObject()) {
                NacosDataJsonParser.parseJsonNode(jsonMap, resultValue, fullKey);
                continue;
            }
            jsonMap.put(fullKey, resultValue.asText());
        }
    }
}

