/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar;

import com.alibaba.cloud.sidecar.SidecarDiscoveryClient;
import com.alibaba.cloud.sidecar.SidecarInstanceCache;
import com.alibaba.cloud.sidecar.SidecarProperties;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.core.env.ConfigurableEnvironment;
import reactor.core.scheduler.Schedulers;

public class SidecarHealthChecker {
    private static final Logger log = LoggerFactory.getLogger(SidecarHealthChecker.class);
    private final Map<String, SidecarInstanceCache> sidecarInstanceCacheMap = new ConcurrentHashMap<String, SidecarInstanceCache>();
    private final SidecarDiscoveryClient sidecarDiscoveryClient;
    private final HealthIndicator healthIndicator;
    private final SidecarProperties sidecarProperties;
    private final ConfigurableEnvironment environment;

    public SidecarHealthChecker(SidecarDiscoveryClient sidecarDiscoveryClient, HealthIndicator healthIndicator, SidecarProperties sidecarProperties, ConfigurableEnvironment environment) {
        this.sidecarDiscoveryClient = sidecarDiscoveryClient;
        this.healthIndicator = healthIndicator;
        this.sidecarProperties = sidecarProperties;
        this.environment = environment;
    }

    public void check() {
        Schedulers.single().schedulePeriodically(() -> {
            String applicationName = this.environment.getProperty("spring.application.name");
            String ip = this.sidecarProperties.getIp();
            Integer port = this.sidecarProperties.getPort();
            Status status = this.healthIndicator.health().getStatus();
            this.instanceCache(applicationName, ip, port, status);
            if (status.equals((Object)Status.UP)) {
                if (this.needRegister(applicationName, ip, port, status)) {
                    this.sidecarDiscoveryClient.registerInstance(applicationName, ip, port);
                    log.info("Polyglot service changed and Health check success. register the new instance. applicationName = {}, ip = {}, port = {}, status = {}", new Object[]{applicationName, ip, port, status});
                }
            } else {
                log.warn("Health check failed. unregister this instance. applicationName = {}, ip = {}, port = {}, status = {}", new Object[]{applicationName, ip, port, status});
                this.sidecarDiscoveryClient.deregisterInstance(applicationName, ip, port);
                this.sidecarInstanceCacheMap.put(applicationName, this.buildCache(ip, port, status));
            }
        }, 0L, this.sidecarProperties.getHealthCheckInterval(), TimeUnit.MILLISECONDS);
    }

    private void instanceCache(String applicationName, String ip, Integer port, Status status) {
        this.sidecarInstanceCacheMap.putIfAbsent(applicationName, this.buildCache(ip, port, status));
    }

    private boolean needRegister(String applicationName, String ip, Integer port, Status status) {
        SidecarInstanceCache cacheRecord = this.sidecarInstanceCacheMap.get(applicationName);
        SidecarInstanceCache cache = this.buildCache(ip, port, status);
        if (!Objects.equals(cache, cacheRecord)) {
            this.sidecarInstanceCacheMap.put(applicationName, cache);
            return true;
        }
        return false;
    }

    private SidecarInstanceCache buildCache(String ip, Integer port, Status status) {
        SidecarInstanceCache cache = new SidecarInstanceCache();
        cache.setIp(ip);
        cache.setPort(port);
        cache.setStatus(status);
        return cache;
    }
}

