/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar;

import com.alibaba.cloud.sidecar.SidecarProperties;
import java.net.URI;
import java.util.Map;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class SidecarHealthIndicator
extends AbstractHealthIndicator {
    private final SidecarProperties sidecarProperties;
    private final RestTemplate restTemplate;

    public SidecarHealthIndicator(SidecarProperties sidecarProperties, RestTemplate restTemplate) {
        this.sidecarProperties = sidecarProperties;
        this.restTemplate = restTemplate;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try {
            URI uri = this.sidecarProperties.getHealthCheckUrl();
            if (uri == null) {
                builder.up();
                return;
            }
            ResponseEntity exchange = this.restTemplate.exchange(uri, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){});
            Map map = (Map)exchange.getBody();
            if (map == null) {
                this.getWarning(builder);
                return;
            }
            Object status = map.get("status");
            if (status instanceof String) {
                builder.status(status.toString());
            } else {
                this.getWarning(builder);
            }
        }
        catch (Exception e) {
            builder.down().withDetail("error", (Object)e.getMessage());
        }
    }

    private void getWarning(Health.Builder builder) {
        builder.unknown().withDetail("warning", (Object)"no status field in response");
    }
}

