/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar.consul;

import com.alibaba.cloud.sidecar.SidecarDiscoveryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;

public class SidecarConsulDiscoveryClient
implements SidecarDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(SidecarConsulDiscoveryClient.class);
    private final ConsulDiscoveryProperties properties;
    private final ConsulServiceRegistry serviceRegistry;
    private final ConsulAutoRegistration registration;

    public SidecarConsulDiscoveryClient(ConsulDiscoveryProperties properties, ConsulServiceRegistry serviceRegistry, ConsulAutoRegistration registration) {
        this.properties = properties;
        this.serviceRegistry = serviceRegistry;
        this.registration = registration;
    }

    @Override
    public void registerInstance(String applicationName, String ip, Integer port) {
        if (!this.properties.isRegister()) {
            log.debug("Registration disabled.");
            return;
        }
        this.serviceRegistry.register((ConsulRegistration)this.registration);
    }

    @Override
    public void deregisterInstance(String applicationName, String ip, Integer port) {
        if (!this.properties.isRegister() || !this.properties.isDeregister()) {
            return;
        }
        this.serviceRegistry.deregister((ConsulRegistration)this.registration);
    }
}

