/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar.consul;

import com.alibaba.cloud.sidecar.SidecarProperties;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.List;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulAutoRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulManagementRegistrationCustomizer;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class SidecarConsulAutoRegistration
extends ConsulAutoRegistration {
    public SidecarConsulAutoRegistration(NewService service, AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers) {
        super(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
    }

    public static ConsulAutoRegistration registration(AutoServiceRegistrationProperties autoServiceRegistrationProperties, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, List<ConsulManagementRegistrationCustomizer> managementRegistrationCustomizers, HeartbeatProperties heartbeatProperties, SidecarProperties sidecarProperties) {
        NewService service = new NewService();
        String appName = SidecarConsulAutoRegistration.getAppName((ConsulDiscoveryProperties)properties, (Environment)context.getEnvironment());
        service.setId(SidecarConsulAutoRegistration.getInstanceId(sidecarProperties, context.getEnvironment()));
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(sidecarProperties.getIp());
        }
        service.setName(SidecarConsulAutoRegistration.normalizeForDns((String)appName));
        service.setTags(SidecarConsulAutoRegistration.createTags((ConsulDiscoveryProperties)properties));
        service.setPort(Integer.valueOf(context.getEnvironment().getProperty("server.port")));
        SidecarConsulAutoRegistration.setCheck((NewService)service, (AutoServiceRegistrationProperties)autoServiceRegistrationProperties, (ConsulDiscoveryProperties)properties, (ApplicationContext)context, (HeartbeatProperties)heartbeatProperties);
        service.setPort(sidecarProperties.getPort());
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, autoServiceRegistrationProperties, properties, context, heartbeatProperties, managementRegistrationCustomizers);
        SidecarConsulAutoRegistration.customize(registrationCustomizers, (ConsulAutoRegistration)registration);
        return registration;
    }

    public static String getInstanceId(SidecarProperties sidecarProperties, Environment environment) {
        return String.format("%s-%s-%s", environment.getProperty("spring.application.name"), sidecarProperties.getIp(), sidecarProperties.getPort());
    }
}

