/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.sidecar.nacos;

import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.sidecar.SidecarDiscoveryClient;
import com.alibaba.cloud.sidecar.nacos.SidecarNacosDiscoveryProperties;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarNacosDiscoveryClient
implements SidecarDiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(SidecarNacosDiscoveryClient.class);
    private NacosServiceManager nacosServiceManager;
    private final SidecarNacosDiscoveryProperties sidecarNacosDiscoveryProperties;

    public SidecarNacosDiscoveryClient(NacosServiceManager nacosServiceManager, SidecarNacosDiscoveryProperties sidecarNacosDiscoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.sidecarNacosDiscoveryProperties = sidecarNacosDiscoveryProperties;
    }

    @Override
    public void registerInstance(String applicationName, String ip, Integer port) {
        try {
            this.namingService().registerInstance(applicationName, this.sidecarNacosDiscoveryProperties.getGroup(), ip, port.intValue());
        }
        catch (NacosException e) {
            log.warn("nacos exception happens", (Throwable)e);
        }
    }

    @Override
    public void deregisterInstance(String applicationName, String ip, Integer port) {
        try {
            this.namingService().deregisterInstance(applicationName, this.sidecarNacosDiscoveryProperties.getGroup(), ip, port.intValue());
        }
        catch (NacosException e) {
            log.warn("nacos exception happens", (Throwable)e);
        }
    }

    private NamingService namingService() {
        return this.nacosServiceManager.getNamingService(this.sidecarNacosDiscoveryProperties.getNacosProperties());
    }
}

