/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol.okhttp;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LoggingInterceptor.class);

    LoggingInterceptor() {
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        long t1 = System.nanoTime();
        log.info(String.format("Sending request %s on %s%n%s", request.url(), chain.connection(), request.headers()));
        Response response = chain.proceed(request);
        long t2 = System.nanoTime();
        log.info(String.format("Received response for %s in %.1fms%n%s", response.request().url(), (double)(t2 - t1) / 1000000.0, response.headers()));
        return response;
    }
}

