/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.audio.omni;

import com.alibaba.dashscope.audio.omni.OmniRealtimeCallback;
import com.alibaba.dashscope.audio.omni.OmniRealtimeConfig;
import com.alibaba.dashscope.audio.omni.OmniRealtimeModality;
import com.alibaba.dashscope.audio.omni.OmniRealtimeParam;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.protocol.DashScopeHeaders;
import com.alibaba.dashscope.protocol.okhttp.OkHttpClientFactory;
import com.alibaba.dashscope.utils.ApiKey;
import com.alibaba.dashscope.utils.Constants;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniRealtimeConversation
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(OmniRealtimeConversation.class);
    private OmniRealtimeParam parameters;
    private OmniRealtimeCallback callback;
    private OkHttpClient client;
    private WebSocket websocktetClient;
    private AtomicBoolean isOpen = new AtomicBoolean(false);
    private AtomicReference<CountDownLatch> connectLatch = new AtomicReference<Object>(null);
    private String sessionId = null;
    private String lastResponseId = null;
    private long lastResponseCreateTime = -1L;
    private long lastFirstAudioDelay = -1L;
    private long lastFirstTextDelay = -1L;
    private AtomicBoolean isClosed = new AtomicBoolean(false);

    public OmniRealtimeConversation(OmniRealtimeParam param, OmniRealtimeCallback callback) {
        this.parameters = param;
        this.callback = callback;
    }

    public void checkStatus() {
        if (this.isClosed.get()) {
            throw new RuntimeException("conversation is already closed!");
        }
    }

    public void connect() throws NoApiKeyException, InterruptedException {
        this.checkStatus();
        Request request = this.buildConnectionRequest(ApiKey.getApiKey(this.parameters.getApikey()), false, this.parameters.getWorkspace(), this.parameters.getHeaders(), this.parameters.getUrl());
        this.client = OkHttpClientFactory.getOkHttpClient();
        this.websocktetClient = this.client.newWebSocket(request, (WebSocketListener)this);
        this.connectLatch.set(new CountDownLatch(1));
        this.connectLatch.get().await();
    }

    public void updateSession(OmniRealtimeConfig config) {
        this.checkStatus();
        JsonObject configJson = config.getConfig();
        HashMap<String, String> update_request = new HashMap<String, String>();
        update_request.put("event_id", this.generateEventId());
        update_request.put("type", "session.update");
        update_request.put("session", (String)configJson);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(update_request), true);
    }

    public void appendAudio(String audioBase64) {
        this.checkStatus();
        HashMap<String, String> append_request = new HashMap<String, String>();
        String event_id = this.generateEventId();
        append_request.put("event_id", event_id);
        append_request.put("type", "input_audio_buffer.append");
        append_request.put("audio", audioBase64);
        log.debug("append audio with eid: {}, length: {}", (Object)event_id, (Object)audioBase64.length());
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(append_request), false);
    }

    public void appendVideo(String videoBase64) {
        this.checkStatus();
        HashMap<String, String> append_request = new HashMap<String, String>();
        String event_id = this.generateEventId();
        append_request.put("event_id", event_id);
        append_request.put("type", "input_image_buffer.append");
        append_request.put("image", videoBase64);
        log.debug("append video with eid: " + event_id + ", length: " + videoBase64.length());
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(append_request), false);
    }

    public void commit() {
        this.checkStatus();
        HashMap<String, String> commit_request = new HashMap<String, String>();
        commit_request.put("event_id", this.generateEventId());
        commit_request.put("type", "input_audio_buffer.commit");
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(commit_request), true);
    }

    public void clearAppendedAudio() {
        this.checkStatus();
        HashMap<String, String> clear_request = new HashMap<String, String>();
        clear_request.put("event_id", this.generateEventId());
        clear_request.put("type", "input_audio_buffer.clear");
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(clear_request), true);
    }

    public void createResponse(String instructions, List<OmniRealtimeModality> modalities) {
        this.checkStatus();
        HashMap<String, Object> create_request = new HashMap<String, Object>();
        create_request.put("event_id", this.generateEventId());
        create_request.put("type", "response.create");
        if (instructions != null || modalities != null) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("instructions", instructions);
            if (modalities != null) {
                response.put("modalities", modalities);
            }
            create_request.put("response", response);
        }
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(create_request), true);
    }

    public void cancelResponse() {
        this.checkStatus();
        HashMap<String, String> cancel_request = new HashMap<String, String>();
        cancel_request.put("event_id", this.generateEventId());
        cancel_request.put("type", "response.cancel");
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        this.sendMessage(gson.toJson(cancel_request), true);
    }

    public void close() {
        this.checkStatus();
        this.websocktetClient.close(1000, "bye");
        this.isClosed.set(true);
    }

    public void close(int code, String reason) {
        this.checkStatus();
        this.websocktetClient.close(code, reason);
        this.isClosed.set(true);
    }

    public void sendRaw(String rawData) {
        this.checkStatus();
        this.sendMessage(rawData, true);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getResponseId() {
        return this.lastResponseId;
    }

    public long getFirstAudioDelay() {
        return this.lastFirstAudioDelay;
    }

    public long getFirstTextDelay() {
        return this.lastFirstTextDelay;
    }

    private Request buildConnectionRequest(String apiKey, boolean isSecurityCheck, String workspace, Map<String, String> customHeaders, String baseWebSocketUrl) throws NoApiKeyException {
        Request.Builder bd = new Request.Builder();
        bd.headers(Headers.of(DashScopeHeaders.buildWebSocketHeaders(apiKey, isSecurityCheck, workspace, customHeaders)));
        String url = Constants.baseWebsocketApiUrl;
        if (baseWebSocketUrl != null) {
            url = baseWebSocketUrl;
        }
        Request request = bd.url(url).build();
        return request;
    }

    private String generateEventId() {
        return "event_" + UUID.randomUUID().toString().replace("-", "");
    }

    private void sendMessage(String message, boolean enableLog) {
        if (enableLog) {
            log.debug("send message: " + message);
        }
        Boolean isOk = this.websocktetClient.send(message);
    }

    private void sendMessage(ByteString message) {
        this.websocktetClient.send(message);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.isOpen.set(true);
        this.connectLatch.get().countDown();
        log.debug("WebSocket opened");
        this.callback.onOpen();
    }

    public void onMessage(WebSocket webSocket, String text) {
        if (text.length() > 1024) {
            log.debug("Received message: " + text.substring(0, 1024));
        } else {
            log.debug("Received message: " + text);
        }
        JsonObject response = JsonUtils.parse(text);
        this.callback.onEvent(response);
        if (response.has("type")) {
            String type;
            switch (type = response.get("type").getAsString()) {
                case "session.created": {
                    this.sessionId = response.get("session").getAsJsonObject().get("id").getAsString();
                    break;
                }
                case "response.created": {
                    this.lastResponseId = response.get("response").getAsJsonObject().get("id").getAsString();
                    this.lastResponseCreateTime = System.currentTimeMillis();
                    this.lastFirstAudioDelay = -1L;
                    this.lastFirstTextDelay = -1L;
                    break;
                }
                case "response.audio_transcript.delta": {
                    if (this.lastResponseCreateTime <= 0L || this.lastFirstTextDelay >= 0L) break;
                    this.lastFirstTextDelay = System.currentTimeMillis() - this.lastResponseCreateTime;
                    break;
                }
                case "response.audio.delta": {
                    if (this.lastResponseCreateTime <= 0L || this.lastFirstAudioDelay >= 0L) break;
                    this.lastFirstAudioDelay = System.currentTimeMillis() - this.lastResponseCreateTime;
                    break;
                }
                case "response.done": {
                    log.debug("[Metric] response: " + this.lastResponseId + ", first text delay: " + this.lastFirstTextDelay + " ms, first audio delay: " + this.lastFirstAudioDelay + " ms");
                }
            }
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.isOpen.set(false);
        this.connectLatch.get().countDown();
        log.debug("WebSocket closed: " + code + ", " + reason);
        this.callback.onClose(code, reason);
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        log.error("WebSocket failed: " + t.getMessage());
    }

    public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        this.isClosed.set(true);
        this.websocktetClient.close(code, reason);
        log.debug("WebSocket closing: " + code + ", " + reason);
    }
}

