/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.registry.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstance;

public class NacosNamingServiceUtils {
    private static final Logger logger = LoggerFactory.getLogger(NacosNamingServiceUtils.class);
    private static final String[] NACOS_PROPERTY_NAMES = NacosNamingServiceUtils.initNacosPropertyNames();

    private static String[] initNacosPropertyNames() {
        return (String[])Stream.of(PropertyKeyConst.class.getFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> Modifier.isFinal(f.getModifiers())).filter(f -> String.class.equals(f.getType())).map(NacosNamingServiceUtils::getConstantValue).filter(Objects::nonNull).map(String::valueOf).toArray(String[]::new);
    }

    private static Object getConstantValue(Field field) {
        Object value = null;
        try {
            value = field.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return value;
    }

    public static Instance toInstance(ServiceInstance serviceInstance) {
        Instance instance = new Instance();
        instance.setInstanceId(serviceInstance.getId());
        instance.setServiceName(serviceInstance.getServiceName());
        instance.setIp(serviceInstance.getHost());
        instance.setPort(serviceInstance.getPort().intValue());
        instance.setMetadata(serviceInstance.getMetadata());
        instance.setEnabled(serviceInstance.isEnabled());
        instance.setHealthy(serviceInstance.isHealthy());
        return instance;
    }

    public static ServiceInstance toServiceInstance(Instance instance) {
        DefaultServiceInstance serviceInstance = new DefaultServiceInstance(instance.getInstanceId(), instance.getServiceName(), instance.getIp(), Integer.valueOf(instance.getPort()));
        serviceInstance.setMetadata(instance.getMetadata());
        serviceInstance.setEnabled(instance.isEnabled());
        serviceInstance.setHealthy(instance.isHealthy());
        return serviceInstance;
    }

    public static String getGroup(URL connectionURL) {
        return connectionURL.getParameter("nacos.group", "DEFAULT_GROUP");
    }

    public static NamingService createNamingService(URL connectionURL) {
        NamingService namingService;
        Properties nacosProperties = NacosNamingServiceUtils.buildNacosProperties(connectionURL);
        try {
            namingService = NacosFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return namingService;
    }

    private static Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        NacosNamingServiceUtils.setServerAddr(url, properties);
        NacosNamingServiceUtils.setProperties(url, properties);
        return properties;
    }

    private static void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, "namingLoadCacheAtStart", "true");
        for (String propertyName : NACOS_PROPERTY_NAMES) {
            NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, propertyName);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        NacosNamingServiceUtils.putPropertyIfAbsent(url, properties, propertyName, null);
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        NacosNamingServiceUtils.putPropertyIfAbsent(properties, propertyName, propertyValue, defaultValue);
    }

    private static void putPropertyIfAbsent(Properties properties, String propertyName, String propertyValue) {
        NacosNamingServiceUtils.putPropertyIfAbsent(properties, propertyName, propertyValue, null);
    }

    private static void putPropertyIfAbsent(Properties properties, String propertyName, String propertyValue, String defaultValue) {
        String value;
        if (StringUtils.isEmpty((String)propertyName) && properties.containsKey(propertyName)) {
            return;
        }
        String string = value = StringUtils.isEmpty((String)propertyValue) ? defaultValue : propertyValue;
        if (StringUtils.isNotEmpty((String)value)) {
            properties.setProperty(propertyName, value);
        }
    }
}

