/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.maintainer.client.address;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosLoadException;
import com.alibaba.nacos.client.address.AbstractServerListManager;
import com.alibaba.nacos.client.env.NacosClientProperties;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;
import com.alibaba.nacos.maintainer.client.remote.HttpClientManager;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultServerListManager
extends AbstractServerListManager {
    private final AtomicInteger currentIndex = new AtomicInteger();

    public DefaultServerListManager(NacosClientProperties properties) {
        super(properties);
    }

    public void start() throws NacosException {
        super.start();
        List serverList = this.getServerList();
        if (serverList.isEmpty()) {
            throw new NacosLoadException("serverList is empty,please check configuration");
        }
        this.currentIndex.set(new Random().nextInt(serverList.size()));
    }

    protected String getModuleName() {
        return "Naming";
    }

    protected NacosRestTemplate getNacosRestTemplate() {
        return HttpClientManager.getInstance().getNacosRestTemplate();
    }

    public String genNextServer() {
        int index = this.currentIndex.incrementAndGet() % this.getServerList().size();
        return (String)this.getServerList().get(index);
    }

    public String getCurrentServer() {
        return (String)this.getServerList().get(this.currentIndex.get() % this.getServerList().size());
    }
}

