/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss;

import com.aliyun.sdk.gateway.oss.Configuration;
import com.aliyun.sdk.gateway.oss.auth.signer.OSSV1Signer;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AddCommonHeadersInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AddMetricInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AdjustClockSkew;
import com.aliyun.sdk.gateway.oss.internal.interceptor.ChecksumValidationInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.FinalizedOutputInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.GenerateUrlInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.MakeMutableHttpRequestInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.MakeMutableResponseInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.ProcPathRegexInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.ProcResponseBodyInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.SelectObjectInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.SigningInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.TransformRequestBodyInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.UrlDecodeEncodeInterceptor;
import com.aliyun.sdk.gateway.oss.policy.OSSUserAgentPolicy;
import com.aliyun.sdk.gateway.oss.policy.retry.OSSRetryPolicy;
import darabonba.core.TeaClientBuilder;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.IClientBuilder;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorChain;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.interceptor.ResponseInterceptor;
import java.net.URI;
import java.util.Optional;

public abstract class BaseClientBuilder<BuilderT extends IClientBuilder<BuilderT, ClientT>, ClientT>
extends TeaClientBuilder<BuilderT, ClientT> {
    private String default_proto = "https";
    private String default_region = "cn-hangzhou";
    private Integer http_port = -1;

    protected String serviceName() {
        return "OSS";
    }

    public BuilderT serviceConfiguration(Configuration serviceConfiguration) {
        this.clientConfiguration.setOption(ClientOption.SERVICE_CONFIGURATION, (Object)serviceConfiguration);
        return (BuilderT)((Object)this);
    }

    protected ClientConfiguration mergeServiceDefaults(ClientConfiguration configuration) {
        return configuration.merge(ClientConfiguration.create().setOption(ClientOption.SERVICE_CONFIGURATION, (Object)Configuration.create()).setOption(ClientOption.RETRY_POLICY, (Object)OSSRetryPolicy.defaultRetryPolicy()).setOption(ClientOption.CLOCK_SKEW_DIFF, (Object)0L).setOption(ClientOption.USER_AGENT_SERVICE_SUFFIX, (Object)OSSUserAgentPolicy.getDefaultUserAgentSuffix()));
    }

    protected ClientConfiguration finalizeServiceConfiguration(ClientConfiguration configuration) {
        Configuration config = (Configuration)configuration.option(ClientOption.SERVICE_CONFIGURATION);
        InterceptorChain chain = InterceptorChain.create();
        chain.addRequestInterceptor((RequestInterceptor)new ProcPathRegexInterceptor());
        SelectObjectInterceptor selectObjectInterceptor = new SelectObjectInterceptor();
        chain.addRequestInterceptor((RequestInterceptor)selectObjectInterceptor);
        chain.addRequestInterceptor((RequestInterceptor)new TransformRequestBodyInterceptor());
        chain.addRequestInterceptor((RequestInterceptor)new AddCommonHeadersInterceptor());
        ChecksumValidationInterceptor checksumInterceptor = new ChecksumValidationInterceptor();
        chain.addRequestInterceptor((RequestInterceptor)checksumInterceptor);
        UrlDecodeEncodeInterceptor urlInterceptor = new UrlDecodeEncodeInterceptor();
        chain.addRequestInterceptor((RequestInterceptor)urlInterceptor);
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new MakeMutableHttpRequestInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new AddMetricInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new SigningInterceptor());
        chain.addHttpRequestInterceptor((HttpRequestInterceptor)new GenerateUrlInterceptor());
        chain.addResponseInterceptor((ResponseInterceptor)new MakeMutableResponseInterceptor());
        chain.addResponseInterceptor((ResponseInterceptor)new ProcResponseBodyInterceptor());
        chain.addResponseInterceptor((ResponseInterceptor)new AdjustClockSkew());
        chain.addResponseInterceptor((ResponseInterceptor)urlInterceptor);
        chain.addResponseInterceptor((ResponseInterceptor)checksumInterceptor);
        chain.addResponseInterceptor((ResponseInterceptor)selectObjectInterceptor);
        chain.addOutputInterceptor((OutputInterceptor)new FinalizedOutputInterceptor());
        configuration.setOption(ClientOption.INTERCEPTOR_CHAIN, (Object)chain);
        configuration.setOption(ClientOption.SIGNER, (Object)new OSSV1Signer());
        configuration.setOption(ClientOption.REGION, (Object)this.resolveRegion(configuration));
        configuration.setOption(ClientOption.HTTP_PORT, (Object)this.resolveHttpPort(configuration));
        configuration.setOption(ClientOption.HTTP_PROTOCOL, (Object)this.resolveHttpProtocol(configuration));
        configuration.setOption(ClientOption.ENDPOINT_URI, (Object)this.resolveEndpointURI(configuration));
        return configuration;
    }

    private String resolveRegion(ClientConfiguration config) {
        return (String)Optional.ofNullable(config.option(ClientOption.REGION)).orElse(this.default_region);
    }

    private Integer resolveHttpPort(ClientConfiguration config) {
        return (Integer)Optional.ofNullable(config.option(ClientOption.HTTP_PORT)).orElse(this.http_port);
    }

    private String resolveHttpProtocol(ClientConfiguration config) {
        return (String)Optional.ofNullable(config.option(ClientOption.HTTP_PROTOCOL)).orElse(this.default_proto);
    }

    private URI resolveEndpointURI(ClientConfiguration config) {
        return Optional.ofNullable(this.endpointURIFromEndpoint(config)).orElse(this.endpointURIFromRegion(config));
    }

    private URI toURI(String value) {
        URI uri = null;
        try {
            uri = new URI(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    private URI endpointURIFromEndpoint(ClientConfiguration config) {
        String value = (String)config.option(ClientOption.ENDPOINT);
        String defaultProto = (String)config.option(ClientOption.HTTP_PROTOCOL);
        if (value != null && !value.contains("://")) {
            value = defaultProto + "://" + value;
        }
        return this.toURI(value);
    }

    private URI endpointURIFromRegion(ClientConfiguration config) {
        String endpoint;
        String region = (String)config.option(ClientOption.REGION);
        String type = (String)Optional.ofNullable(config.option(ClientOption.ENDPOINT_TYPE)).orElse("public");
        String proto = (String)config.option(ClientOption.HTTP_PROTOCOL);
        switch (type.toLowerCase()) {
            case "internal": 
            case "intranet": {
                endpoint = "oss-" + region + "-internal.aliyuncs.com";
                break;
            }
            case "accelerate": {
                endpoint = "oss-accelerate.aliyuncs.com";
                break;
            }
            case "accelerate-overseas": {
                endpoint = "oss-accelerate-overseas.aliyuncs.com";
                break;
            }
            case "dualstack": {
                endpoint = region + ".oss.aliyuncs.com";
                break;
            }
            default: {
                endpoint = "oss-" + region + ".aliyuncs.com";
            }
        }
        return this.toURI(proto + "://" + endpoint);
    }
}

