/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.BinaryUtils;
import com.aliyun.core.utils.XmlUtil;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequest;
import darabonba.core.TeaRequestBody;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import darabonba.core.sync.RequestBody;
import darabonba.core.utils.CommonUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;

public class TransformRequestBodyInterceptor
implements RequestInterceptor {
    private static final RequestBody EmptyBody = RequestBody.empty();

    private static String convertXMLRootName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        if (request.body() != null) {
            return this.fromBody(context, attributes);
        }
        if (context.teaRequestBody() != null) {
            return this.fromRequestBody(context, attributes);
        }
        if (request.stream() != null) {
            return this.fromStream(context, attributes);
        }
        request.headers().set("Content-Type", this.toContentType(request.reqBodyType()));
        attributes.put(AttributeKey.REQUEST_BODY, (Object)EmptyBody);
        return request;
    }

    private TeaRequest fromBody(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        String bodyStr = null;
        switch (request.reqBodyType()) {
            case "xml": {
                Map body = CommonUtil.assertAsMap((Object)request.body());
                if (!body.isEmpty()) {
                    String root = (String)body.keySet().iterator().next();
                    bodyStr = XmlUtil.serializeXml((Map)CommonUtil.assertAsMap(body.get(root)), (String)TransformRequestBodyInterceptor.convertXMLRootName(root));
                }
                this.calcContentMd5IfNeed(bodyStr, attributes);
                break;
            }
            default: {
                Map body = CommonUtil.assertAsMap((Object)request.body());
                bodyStr = (String)body.get("body");
            }
        }
        if (bodyStr == null) {
            bodyStr = "";
        }
        attributes.put(AttributeKey.REQUEST_BODY, (Object)RequestBody.fromString((String)bodyStr, (Charset)StandardCharsets.UTF_8, (String)this.toContentType(request.reqBodyType())));
        request.headers().set("Content-Type", this.toContentType(request.reqBodyType()));
        return request;
    }

    private TeaRequest fromStream(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        RequestBody requestBody = RequestBody.fromInputStream((InputStream)request.stream());
        attributes.put(AttributeKey.REQUEST_BODY, (Object)Optional.ofNullable(requestBody).orElse(EmptyBody));
        return request;
    }

    private TeaRequest fromRequestBody(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        TeaRequestBody requestBody = context.teaRequestBody();
        if (requestBody.contentLength().isPresent()) {
            attributes.put(AttributeKey.REQUEST_BODY_LENGTH, requestBody.contentLength().get());
        }
        attributes.put(AttributeKey.REQUEST_BODY, (Object)requestBody);
        return request;
    }

    private String toContentType(String type) {
        switch (type) {
            case "xml": {
                return "application/xml";
            }
            case "json": {
                return "application/json";
            }
        }
        return "application/octet-stream";
    }

    private void calcContentMd5IfNeed(String body, AttributeMap attributes) {
        if (body == null) {
            return;
        }
        byte[] md5 = BinaryUtils.calculateMd5((byte[])body.getBytes(StandardCharsets.UTF_8));
        String md5Base64 = BinaryUtils.toBase64((byte[])md5);
        attributes.put(AttributeKey.OSS_XML_BODY_CONTENT_MD5, (Object)md5Base64);
    }
}

