package com.aliyun.sdk.gateway.pop.auth;

public enum SignatureAlgorithm {
    HMAC_SHA1("HMAC-SHA1"),
    ACS3_HMAC_SHA256("ACS3-HMAC-SHA256"),
    ACS3_HMAC_SM3("ACS3-HMAC-SM3"),
    ACS3_RSA_SHA256("ACS3-RSA-SHA256"),
    ACS4_HMAC_SHA256("ACS4-HMAC-SHA256"),
    ACS4_HMAC_SM3("ACS4-HMAC-SM3"),
    UNKNOWN("UNKNOWN");

    private final String algorithmName;

    SignatureAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String algorithmName() {
        return algorithmName;
    }
}
