/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.pop.auth.signer;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSHA256;
import com.aliyun.auth.signature.signer.SignAlgorithmHmacSM3;
import com.aliyun.sdk.gateway.pop.auth.SignatureAlgorithm;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.auth.signer.PopSigner;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PopV4Signer
implements PopSigner {
    private final String ENCODING = "UTF-8";
    private final String HASH_SHA256 = "SHA-256";
    private final String HASH_SM3 = "SM3";
    private final SignatureAlgorithm DEFAULT_ALGORITHM = SignatureAlgorithm.ACS4_HMAC_SHA256;
    private final String algorithm;

    public PopV4Signer() {
        this.algorithm = this.DEFAULT_ALGORITHM.algorithmName();
    }

    public PopV4Signer(SignatureAlgorithm algorithm) {
        this.algorithm = algorithm != null ? algorithm.algorithmName() : this.DEFAULT_ALGORITHM.algorithmName();
    }

    public PopV4Signer(String algorithm) {
        this.algorithm = algorithm != null ? algorithm : this.DEFAULT_ALGORITHM.algorithmName();
    }

    @Override
    public byte[] signString(String stringToSign, byte[] signingKey) {
        try {
            if (this.algorithm.endsWith("HMAC-SHA256")) {
                Mac sha256HMAC = SignAlgorithmHmacSHA256.HmacSHA256.getMac();
                sha256HMAC.init(new SecretKeySpec(signingKey, SignAlgorithmHmacSHA256.HmacSHA256.toString()));
                return sha256HMAC.doFinal(stringToSign.getBytes("UTF-8"));
            }
            if (this.algorithm.endsWith("HMAC-SM3")) {
                HMac sm3HMAC = SignAlgorithmHmacSM3.HMAC_SM3.getMac();
                SecretKeySpec key = new SecretKeySpec(signingKey, SignAlgorithmHmacSM3.HMAC_SM3.toString());
                byte[] sm3Sign = new byte[sm3HMAC.getMacSize()];
                byte[] inputBytes = stringToSign.getBytes("UTF-8");
                sm3HMAC.init((CipherParameters)new KeyParameter(key.getEncoded()));
                sm3HMAC.update(inputBytes, 0, inputBytes.length);
                sm3HMAC.doFinal(sm3Sign, 0);
                return sm3Sign;
            }
            throw new SignatureException("Unsupported algorithm: " + this.algorithm);
        }
        catch (UnsupportedEncodingException | InvalidKeyException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public byte[] signString(String stringToSign, String signingKey) {
        try {
            return this.signString(stringToSign, signingKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public byte[] hash(byte[] raw) {
        if (null == raw) {
            return null;
        }
        try {
            MessageDigest digest;
            if (this.algorithm.endsWith("HMAC-SHA256")) {
                digest = MessageDigest.getInstance("SHA-256");
            } else if (this.algorithm.endsWith("HMAC-SM3")) {
                BouncyCastleProvider provider = new BouncyCastleProvider();
                digest = MessageDigest.getInstance("SM3", (Provider)provider);
            } else {
                throw new SignatureException("Unsupported algorithm: " + this.algorithm);
            }
            return digest.digest(raw);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    public String getContent() {
        if (this.algorithm.endsWith("HMAC-SHA256")) {
            return "x-acs-content-sha256";
        }
        if (this.algorithm.endsWith("HMAC-SM3")) {
            return "x-acs-content-sm3";
        }
        throw new SignatureException("Unsupported algorithm: " + this.algorithm);
    }

    @Override
    public String getSignerName() {
        return this.algorithm;
    }

    @Override
    public SignatureVersion getSignerVersion() {
        return SignatureVersion.V4;
    }
}

