package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.*;
import com.aliyun.auth.credentials.utils.*;
import com.aliyun.core.utils.StringUtils;

public class EnvironmentVariableCredentialProvider implements ICredentialProvider {

    public static EnvironmentVariableCredentialProvider create() {
        return new EnvironmentVariableCredentialProvider();
    }

    @Override
    public ICredential getCredentials() {
        String accessKeyId = AuthUtils.getEnvironmentAccessKeyId();
        String accessKeySecret = AuthUtils.getEnvironmentAccessKeySecret();
        String securityToken = AuthUtils.getEnvironmentSecurityToken();
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("Environment variable accessKeyId/accessKeySecret cannot be empty");
        }
        if (!StringUtils.isEmpty(securityToken)) {
            return Credential.builder()
                    .accessKeyId(accessKeyId)
                    .accessKeySecret(accessKeySecret)
                    .securityToken(securityToken)
                    .build();
        }
        return Credential.builder()
                .accessKeyId(accessKeyId)
                .accessKeySecret(accessKeySecret)
                .build();
    }

    @Override
    public void close() {
    }
}
