/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.http;

import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpClientType;
import com.aliyuncs.http.IHttpClient;
import com.aliyuncs.http.clients.ApacheHttpClient;
import com.aliyuncs.http.clients.CompatibleUrlConnClient;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.utils.StringUtils;
import java.lang.reflect.Constructor;

public class HttpClientFactory {
    public static String HTTP_CLIENT_IMPL_KEY = "aliyuncs.sdk.httpclient";
    public static String COMPATIBLE_HTTP_CLIENT_CLASS_NAME = CompatibleUrlConnClient.class.getName();

    public static IHttpClient buildClient(IClientProfile profile) {
        try {
            Class<?> httpClientClass;
            String customClientClassName;
            HttpClientConfig clientConfig = profile.getHttpClientConfig();
            if (clientConfig == null) {
                clientConfig = HttpClientConfig.getDefault();
                profile.setHttpClientConfig(clientConfig);
            }
            if (StringUtils.isEmpty(customClientClassName = clientConfig.isCompatibleMode() ? COMPATIBLE_HTTP_CLIENT_CLASS_NAME : (clientConfig.getClientType() == HttpClientType.Custom && !StringUtils.isEmpty(clientConfig.getCustomClientClassName()) ? clientConfig.getCustomClientClassName() : System.getProperty(HTTP_CLIENT_IMPL_KEY)))) {
                customClientClassName = clientConfig.getClientType().getImplClass().getName();
            }
            if (!IHttpClient.class.isAssignableFrom(httpClientClass = Class.forName(customClientClassName))) {
                throw new IllegalStateException(String.format("%s is not assignable from com.aliyuncs.http.IHttpClient", customClientClassName));
            }
            if (ApacheHttpClient.class.equals(httpClientClass)) {
                ApacheHttpClient client = ApacheHttpClient.getInstance();
                ((IHttpClient)client).init(clientConfig);
                return client;
            }
            Constructor<?> constructor = httpClientClass.getConstructor(HttpClientConfig.class);
            return (IHttpClient)constructor.newInstance(clientConfig);
        }
        catch (Exception e) {
            throw new IllegalStateException("HttpClientFactory buildClient failed", e);
        }
    }
}

