/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client;

import com.aliyun.mqs.client.DefaultMQSClient;
import com.aliyun.mqs.client.MQSClient;
import com.aliyun.mqs.client.Utils;
import com.aliyun.mqs.client.impl.GetAccountAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.ServiceException;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.ClientConfiguration;
import com.aliyun.mqs.common.http.DefaultServiceClient;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.model.GetAccountRequest;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CloudAccount {
    private static Log log = LogFactory.getLog(CloudAccount.class);
    private String accessId;
    private String accessKey;
    private String serviceAddress = "http://mqs-cn-hangzhou.aliyuncs.com";
    private URI endpoint;
    private ServiceClient serviceClient;
    private ServiceCredentials credentials = new ServiceCredentials();
    private ClientConfiguration config;
    private String accountEndpoint;
    private String accountId;
    private MQSClient mqsClient;

    public String getAccountId() {
        if (this.accountId == null) {
            GetAccountAction action = new GetAccountAction(this.serviceClient, this.credentials, this.endpoint);
            GetAccountRequest reqObject = new GetAccountRequest();
            reqObject.setRequestPath("/");
            this.accountId = (String)action.execute(reqObject);
            if (this.accountId == null) {
                throw new IllegalArgumentException("Illegal credential.");
            }
        }
        return this.accountId;
    }

    public String getAccountEndpoint() throws ServiceException, ClientException {
        if (this.accountEndpoint == null) {
            this.getAccountId();
            String addr = this.endpoint.getScheme() + "://" + this.accountId + "." + this.endpoint.getHost();
            if (this.endpoint.getPort() != 80 && this.endpoint.getPort() > 0) {
                addr = addr + ":" + this.endpoint.getPort();
            }
            this.accountEndpoint = addr;
        }
        return this.accountEndpoint;
    }

    public MQSClient getMQSClient() throws ServiceException, ClientException {
        if (this.mqsClient == null) {
            String accountEndpoint = this.getAccountEndpoint();
            this.mqsClient = new DefaultMQSClient(this.credentials, this.serviceClient, accountEndpoint);
        }
        return this.mqsClient;
    }

    public CloudAccount(String accessId, String accessKey) {
        this(accessId, accessKey, null);
    }

    public CloudAccount(String accessId, String accessKey, String serviceAddress) {
        this(accessId, accessKey, serviceAddress, null);
    }

    public CloudAccount(String accessId, String accessKey, String serviceAddress, ClientConfiguration config) {
        this.accessId = accessId;
        this.accessKey = accessKey;
        if (serviceAddress != null) {
            this.serviceAddress = serviceAddress;
        }
        this.config = config;
        this.init();
    }

    private void init() {
        this.setEndpoint(this.serviceAddress);
        this.credentials = new ServiceCredentials(this.accessId, this.accessKey);
        if (this.config == null) {
            this.config = new ClientConfiguration();
        }
        this.serviceClient = new DefaultServiceClient(this.config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("initiated CloudAccount, accessId=" + this.accessId + ",accessKey=" + this.accessKey + ", endpoint=" + this.serviceAddress));
        }
    }

    private void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = Utils.getHttpURI(endpoint);
    }
}

