/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client;

import com.aliyun.mqs.client.AsyncCallback;
import com.aliyun.mqs.client.AsyncResult;
import com.aliyun.mqs.client.impl.ChangeVisibilityTimeoutAction;
import com.aliyun.mqs.client.impl.CreateQueueAction;
import com.aliyun.mqs.client.impl.DeleteMessageAction;
import com.aliyun.mqs.client.impl.DeleteQueueAction;
import com.aliyun.mqs.client.impl.GetQueueAttrAction;
import com.aliyun.mqs.client.impl.PeekMessageAction;
import com.aliyun.mqs.client.impl.ReceiveMessageAction;
import com.aliyun.mqs.client.impl.SendMessageAction;
import com.aliyun.mqs.client.impl.SetQueueAttrAction;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.ServiceException;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.model.ChangeVisibilityTimeoutRequest;
import com.aliyun.mqs.model.CreateQueueRequest;
import com.aliyun.mqs.model.DeleteMessageRequest;
import com.aliyun.mqs.model.DeleteQueueRequest;
import com.aliyun.mqs.model.GetQueueAttrRequest;
import com.aliyun.mqs.model.Message;
import com.aliyun.mqs.model.PeekMessageRequest;
import com.aliyun.mqs.model.QueueMeta;
import com.aliyun.mqs.model.ReceiveMessageRequest;
import com.aliyun.mqs.model.SendMessageRequest;
import com.aliyun.mqs.model.SetQueueAttrRequest;
import java.net.URI;

public final class CloudQueue {
    private ServiceClient serviceClient;
    private String queueURL;
    private ServiceCredentials credentials;
    private URI endpoint;
    private boolean encoding;

    protected CloudQueue(String queueURL, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.serviceClient = client;
        this.credentials = credentials;
        this.endpoint = endpoint;
        if (queueURL == null || queueURL.equals("")) {
            throw new NullPointerException("QueueURL parameter can not be empty.");
        }
        String uri = endpoint.toString();
        if (queueURL.startsWith(uri)) {
            this.queueURL = queueURL;
        } else {
            if (!(uri.endsWith("/") || queueURL != null && queueURL.startsWith("/"))) {
                uri = uri + "/";
            }
            if (queueURL != null) {
                uri = uri + queueURL;
            }
            this.queueURL = uri;
        }
        this.setEncoding(true);
    }

    public String create() throws ServiceException, ClientException {
        return this.create(null);
    }

    public String create(QueueMeta queueMeta) throws ServiceException, ClientException {
        CreateQueueAction action = new CreateQueueAction(this.serviceClient, this.credentials, this.endpoint);
        String queueName = this.drillQueueName();
        CreateQueueRequest request = new CreateQueueRequest();
        if (queueMeta == null || queueMeta.getQueueName() == null) {
            queueMeta = new QueueMeta();
            queueMeta.setQueueName(queueName);
        } else if (queueMeta.getQueueName() == null || queueMeta.getQueueName().isEmpty()) {
            queueMeta.setQueueName(queueName);
        } else if (!queueName.equals(queueMeta.getQueueName())) {
            throw new ClientException("QueueName conflict between meta queue name and  queue url offered.");
        }
        request.setRequestPath(queueMeta.getQueueName());
        request.setQueueMeta(queueMeta);
        String queueLocation = (String)action.execute(request);
        CloudQueue queue = new CloudQueue(queueLocation, this.serviceClient, this.credentials, this.endpoint);
        return queue.getQueueURL();
    }

    private String drillQueueName() {
        String queueName = null;
        for (queueName = this.queueURL.startsWith(this.endpoint.toString()) ? this.queueURL.substring(this.endpoint.toString().length() + 1) : this.queueURL; queueName != null && queueName.trim().length() > 0 && queueName.startsWith("/"); queueName = queueName.substring(1)) {
        }
        if (queueName == null || queueName.trim().length() == 0) {
            throw new NullPointerException("Queue Name can not be null.");
        }
        return queueName;
    }

    public void delete() throws ServiceException, ClientException {
        DeleteQueueAction action = new DeleteQueueAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteQueueRequest request = new DeleteQueueRequest();
        request.setRequestPath(this.queueURL);
        action.execute(request);
    }

    public QueueMeta getAttributes() throws ServiceException, ClientException {
        GetQueueAttrAction action = new GetQueueAttrAction(this.serviceClient, this.credentials, this.endpoint);
        GetQueueAttrRequest request = new GetQueueAttrRequest();
        request.setRequestPath(this.queueURL);
        QueueMeta meta = (QueueMeta)action.execute(request);
        meta.setQueueURL(this.queueURL);
        return meta;
    }

    public void setAttributes(QueueMeta queueMeta) throws ClientException, ServiceException {
        SetQueueAttrAction action = new SetQueueAttrAction(this.serviceClient, this.credentials, this.endpoint);
        SetQueueAttrRequest request = new SetQueueAttrRequest();
        request.setQueueMeta(queueMeta);
        request.setRequestPath(this.queueURL);
        action.execute(request);
    }

    public Message peekMessage() throws ServiceException, ClientException {
        PeekMessageAction action = new PeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        PeekMessageRequest request = new PeekMessageRequest();
        request.setRequestPath(this.queueURL);
        try {
            return (Message)action.execute(request);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<Message> asyncPeekMessage(AsyncCallback<Message> callback) {
        PeekMessageAction action = new PeekMessageAction(this.serviceClient, this.credentials, this.endpoint);
        PeekMessageRequest request = new PeekMessageRequest();
        request.setRequestPath(this.queueURL);
        return action.execute(request, callback);
    }

    public String changeMessageVisibilityTimeout(String receiptHandle, int visibilityTimeout) throws ServiceException, ClientException {
        ChangeVisibilityTimeoutAction action = new ChangeVisibilityTimeoutAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return (String)action.execute(request);
    }

    public AsyncResult<String> asyncChangeMessageVisibilityTimeout(String receiptHandle, int visibilityTimeout, AsyncCallback<String> callback) {
        ChangeVisibilityTimeoutAction action = new ChangeVisibilityTimeoutAction(this.serviceClient, this.credentials, this.endpoint);
        ChangeVisibilityTimeoutRequest request = new ChangeVisibilityTimeoutRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        request.setVisibilityTimeout(visibilityTimeout);
        return action.execute(request, callback);
    }

    public Message popMessage() throws ServiceException, ClientException {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        try {
            return (Message)action.execute(request);
        }
        catch (ServiceException e) {
            if (!this.isMessageNotExist(e)) {
                throw e;
            }
            return null;
        }
    }

    public AsyncResult<Message> asyncPopMessage(AsyncCallback<Message> callback) {
        ReceiveMessageAction action = new ReceiveMessageAction(this.serviceClient, this.credentials, this.endpoint);
        ReceiveMessageRequest request = new ReceiveMessageRequest();
        request.setRequestPath(this.queueURL);
        return action.execute(request, callback);
    }

    public AsyncResult<Void> asyncDeleteMessage(String receiptHandle, AsyncCallback<Void> callback) {
        DeleteMessageAction action = new DeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        return action.execute(request, callback);
    }

    public void deleteMessage(String receiptHandle) throws ServiceException, ClientException {
        DeleteMessageAction action = new DeleteMessageAction(this.serviceClient, this.credentials, this.endpoint);
        DeleteMessageRequest request = new DeleteMessageRequest();
        request.setRequestPath(this.queueURL);
        request.setReceiptHandle(receiptHandle);
        action.execute(request);
    }

    public AsyncResult<Message> asyncPutMessage(Message message, AsyncCallback<Message> callback) {
        SendMessageAction action = new SendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        SendMessageRequest request = new SendMessageRequest();
        request.setMessage(message);
        request.setRequestPath(this.queueURL);
        return action.execute(request, callback);
    }

    public Message putMessage(Message message) throws ServiceException, ClientException {
        SendMessageAction action = new SendMessageAction(this.serviceClient, this.credentials, this.endpoint);
        SendMessageRequest request = new SendMessageRequest();
        request.setMessage(message);
        request.setRequestPath(this.queueURL);
        return (Message)action.execute(request);
    }

    public boolean isEncoding() {
        return this.encoding;
    }

    public void setEncoding(boolean encoding) {
        this.encoding = encoding;
    }

    public String getQueueURL() {
        return this.queueURL;
    }

    boolean isMessageNotExist(ServiceException e) {
        return "MessageNotExist".equals(e.getErrorCode());
    }

    public void close() {
        if (this.serviceClient != null) {
            this.serviceClient.close();
        }
    }
}

