/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mqs.client.impl;

import com.aliyun.mqs.client.AsyncCallback;
import com.aliyun.mqs.client.AsyncResult;
import com.aliyun.mqs.client.impl.Action;
import com.aliyun.mqs.common.ClientException;
import com.aliyun.mqs.common.HttpMethod;
import com.aliyun.mqs.common.ServiceException;
import com.aliyun.mqs.common.auth.ServiceCredentials;
import com.aliyun.mqs.common.auth.ServiceSignature;
import com.aliyun.mqs.common.comm.ExecutionContext;
import com.aliyun.mqs.common.http.ExceptionResultParser;
import com.aliyun.mqs.common.http.HttpCallback;
import com.aliyun.mqs.common.http.RequestMessage;
import com.aliyun.mqs.common.http.ServiceClient;
import com.aliyun.mqs.common.parser.ResultParser;
import com.aliyun.mqs.common.utils.DateUtil;
import com.aliyun.mqs.model.AbstractRequest;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractAction<T extends AbstractRequest, V>
implements Action<T, V> {
    private ServiceClient client;
    private ServiceCredentials credentials;
    private HttpMethod method;
    private URI endpoint;
    protected String actionName = "";

    public AbstractAction(HttpMethod method, String actionName, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        this.method = method;
        this.actionName = actionName;
        this.client = client;
        this.endpoint = endpoint;
        this.credentials = credentials;
    }

    @Override
    public String getActionName() {
        return this.actionName;
    }

    @Override
    public ServiceClient getClient() {
        return this.client;
    }

    @Override
    public ServiceCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public AsyncResult<V> execute(T reqObject, AsyncCallback<V> asyncHandler) throws ClientException, ServiceException {
        if (this.validate(reqObject)) {
            RequestMessage request = this.buildRequestMessage(reqObject);
            request.setMethod(this.getMethod());
            this.addRequiredHeader(request);
            this.addSignatureHeader(request);
            ExceptionResultParser exceptionParser = new ExceptionResultParser();
            HttpCallback<V> callback = new HttpCallback<V>(this.buildResultParser(), exceptionParser, asyncHandler);
            AsyncResult<V> asyncResult = callback.getAsyncResult();
            this.client.sendRequest(request, new ExecutionContext(), callback);
            return asyncResult;
        }
        return null;
    }

    @Override
    public V execute(T reqObject) throws ClientException, ServiceException {
        AsyncResult<V> result = this.execute(reqObject, null);
        V value = result.getResult();
        if (result.isSuccess()) {
            return value;
        }
        if (result.getException() instanceof ClientException) {
            throw (ClientException)result.getException();
        }
        if (result.getException() instanceof ServiceException) {
            throw (ServiceException)result.getException();
        }
        throw new ServiceException(result.getException().getMessage(), result.getException());
    }

    protected void addRequiredHeader(RequestMessage request) {
        request.getHeaders().put("x-mqs-version", "2014-07-08");
        if (request.getHeaders().get("Date") == null) {
            request.getHeaders().put("Date", DateUtil.formatRfc822Date(new Date()));
        }
        if (request.getHeaders().get("Content-Type") == null) {
            request.getHeaders().put("Content-Type", "text/xml;charset=UTF-8");
        }
    }

    protected void addSignatureHeader(RequestMessage request) throws ClientException {
        if (this.credentials != null && this.credentials.getAccessKeyId() != null && this.credentials.getAccessKeySecret() != null) {
            request.addHeader("Authorization", "MQS " + this.credentials.getAccessKeyId() + ":" + this.getSignature(request));
        }
    }

    private String getRelativeResourcePath(String subPath) {
        String rootPath = this.endpoint.getPath();
        if (subPath != null && !"".equals(subPath.trim())) {
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            if (!rootPath.endsWith("/")) {
                return rootPath + "/" + subPath;
            }
            return rootPath + subPath;
        }
        return rootPath;
    }

    private String getSignature(RequestMessage request) throws ClientException {
        Map<String, String> headers = request.getHeaders();
        StringBuffer canonicalizedMQSHeaders = new StringBuffer();
        StringBuffer stringToSign = new StringBuffer();
        String contentMd5 = AbstractAction.safeGetHeader("Content-MD5", headers);
        String contentType = AbstractAction.safeGetHeader("Content-Type", headers);
        String date = AbstractAction.safeGetHeader("Date", headers);
        String canonicalizedResource = this.getRelativeResourcePath(request.getResourcePath());
        TreeMap<String, String> tmpHeaders = AbstractAction.sortHeader(request.getHeaders());
        if (tmpHeaders.size() > 0) {
            Set<String> keySet = tmpHeaders.keySet();
            for (String key : keySet) {
                if (!key.toLowerCase().startsWith("x-mqs-")) continue;
                canonicalizedMQSHeaders.append(key).append(":").append(tmpHeaders.get(key)).append("\n");
            }
        }
        stringToSign.append((Object)this.method).append("\n").append(contentMd5).append("\n").append(contentType).append("\n").append(date).append("\n").append(canonicalizedMQSHeaders).append(canonicalizedResource);
        String signature = "";
        try {
            signature = ServiceSignature.create().computeSignature(this.credentials.getAccessKeySecret(), stringToSign.toString());
        }
        catch (Exception e) {
            throw new ClientException("Signature fail", e);
        }
        return signature;
    }

    protected boolean validate(T request) throws ClientException {
        return true;
    }

    private static TreeMap<String, String> sortHeader(Map<String, String> headers) {
        TreeMap<String, String> tmpHeaders = new TreeMap<String, String>();
        Set<String> keySet = headers.keySet();
        for (String key : keySet) {
            if (key.toLowerCase().startsWith("x-mqs-")) {
                tmpHeaders.put(key.toLowerCase(), headers.get(key));
                continue;
            }
            tmpHeaders.put(key, headers.get(key));
        }
        return tmpHeaders;
    }

    private static String safeGetHeader(String key, Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        String value = headers.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected RequestMessage buildRequestMessage(T reqObject) throws ClientException {
        RequestMessage request = this.buildRequest(reqObject);
        String requestPath = request.getResourcePath();
        if (requestPath != null && requestPath.startsWith("http://")) {
            if (!requestPath.startsWith(this.endpoint.toString())) {
                throw new IllegalArgumentException("Endpoint[" + this.endpoint.toString() + "]\u548c\u8bbf\u95ee\u5730\u5740[" + requestPath + "]\u4e0d\u5339\u914d.");
            }
            request.setResourcePath(requestPath.substring(this.endpoint.toString().length()));
        }
        request.setEndpoint(this.endpoint);
        this.addRequiredHeader(request);
        this.addSignatureHeader(request);
        return request;
    }

    protected abstract ResultParser<V> buildResultParser();

    protected abstract RequestMessage buildRequest(T var1) throws ClientException;
}

